/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader;

import java.io.IOException;
import java.util.List;
import org.springframework.boot.loader.ExecutableArchiveLauncher;
import org.springframework.boot.loader.archive.Archive;

public class WarLauncher
extends ExecutableArchiveLauncher {
    @Override
    public boolean isNestedArchive(Archive.Entry entry) {
        if (entry.isDirectory()) {
            return entry.getName().equals("WEB-INF/classes/");
        }
        return entry.getName().startsWith("WEB-INF/lib/") || entry.getName().startsWith("WEB-INF/lib-provided/");
    }

    @Override
    protected void postProcessClassPathArchives(List<Archive> archives) throws Exception {
        archives.add(0, this.getFilteredArchive());
    }

    protected Archive getFilteredArchive() throws IOException {
        return this.getArchive().getFilteredArchive(new Archive.EntryRenameFilter(){

            @Override
            public String apply(String entryName, Archive.Entry entry) {
                if (entryName.startsWith("META-INF/") || entryName.startsWith("WEB-INF/")) {
                    return null;
                }
                return entryName;
            }
        });
    }

    public static void main(String[] args) {
        new WarLauncher().launch(args);
    }
}

