/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.autoconfigure;

import io.netty.buffer.PooledByteBufAllocator;
import io.rsocket.RSocket;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.rsocket.messaging.RSocketStrategiesCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.codec.cbor.JacksonCborDecoder;
import org.springframework.http.codec.cbor.JacksonCborEncoder;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.RouteMatcher;
import org.springframework.web.util.pattern.PathPatternRouteMatcher;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.dataformat.cbor.CBORFactory;
import tools.jackson.dataformat.cbor.CBORMapper;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration"})
@ConditionalOnClass(value={RSocket.class, RSocketStrategies.class, PooledByteBufAllocator.class})
public final class RSocketStrategiesAutoConfiguration {
    private static final String PATHPATTERN_ROUTEMATCHER_CLASS = "org.springframework.web.util.pattern.PathPatternRouteMatcher";

    @Bean
    @ConditionalOnMissingBean
    RSocketStrategies rSocketStrategies(ObjectProvider<RSocketStrategiesCustomizer> customizers) {
        RSocketStrategies.Builder builder = RSocketStrategies.builder();
        if (ClassUtils.isPresent((String)PATHPATTERN_ROUTEMATCHER_CLASS, null)) {
            builder.routeMatcher((RouteMatcher)new PathPatternRouteMatcher());
        }
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    protected static class JacksonJsonStrategyConfiguration {
        private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")};

        protected JacksonJsonStrategyConfiguration() {
        }

        @Bean
        @Order(value=1)
        @ConditionalOnBean(value={JsonMapper.class})
        RSocketStrategiesCustomizer jacksonJsonRSocketStrategyCustomizer(JsonMapper jsonMapper) {
            return strategy -> {
                strategy.decoder(new Decoder[]{new JacksonJsonDecoder(jsonMapper, (MimeType[])SUPPORTED_TYPES)});
                strategy.encoder(new Encoder[]{new JacksonJsonEncoder(jsonMapper, (MimeType[])SUPPORTED_TYPES)});
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={JsonMapper.Builder.class})
    @ConditionalOnClass(value={ObjectMapper.class, CBORFactory.class})
    protected static class JacksonCborStrategyConfiguration {
        private static final MediaType[] SUPPORTED_TYPES = new MediaType[]{MediaType.APPLICATION_CBOR};

        protected JacksonCborStrategyConfiguration() {
        }

        @Bean
        @Order(value=0)
        RSocketStrategiesCustomizer jacksonCborRSocketStrategyCustomizer(JsonMapper.Builder builder) {
            return strategy -> {
                CBORMapper cborMapper = ((CBORMapper.Builder)CBORMapper.builder().baseSettings(builder.baseSettings())).build();
                strategy.decoder(new Decoder[]{new JacksonCborDecoder(cborMapper, (MimeType[])SUPPORTED_TYPES)});
                strategy.encoder(new Encoder[]{new JacksonCborEncoder(cborMapper, (MimeType[])SUPPORTED_TYPES)});
            };
        }
    }
}

