/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.resttestclient.autoconfigure;

import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.resttestclient.autoconfigure.RestTestClientBuilderCustomizer;
import org.springframework.boot.resttestclient.autoconfigure.SpringBootRestTestClientBuilderCustomizer;
import org.springframework.boot.test.http.server.LocalTestWebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.client.RestTestClient;
import org.springframework.web.client.RestClient;
import org.springframework.web.context.WebApplicationContext;

@AutoConfiguration
@ConditionalOnClass(value={RestClient.class, RestTestClient.class, ClientHttpMessageConvertersCustomizer.class})
final class RestTestClientTestAutoConfiguration {
    RestTestClientTestAutoConfiguration() {
    }

    @Bean
    SpringBootRestTestClientBuilderCustomizer springBootRestTestClientBuilderCustomizer(ObjectProvider<ClientHttpMessageConvertersCustomizer> httpMessageConverterCustomizers) {
        return new SpringBootRestTestClientBuilderCustomizer(httpMessageConverterCustomizers.orderedStream().toList());
    }

    @Bean
    @ConditionalOnMissingBean
    RestTestClient restTestClient(WebApplicationContext applicationContext, List<RestTestClientBuilderCustomizer> customizers) {
        RestTestClient.Builder<?> builder = this.getBuilder(applicationContext);
        customizers.forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    private RestTestClient.Builder<?> getBuilder(WebApplicationContext applicationContext) {
        LocalTestWebServer localTestWebServer = LocalTestWebServer.get((ApplicationContext)applicationContext);
        if (localTestWebServer != null) {
            return RestTestClient.bindToServer().uriBuilderFactory(localTestWebServer.uriBuilderFactory());
        }
        if (this.hasBean((ApplicationContext)applicationContext, MockMvc.class)) {
            return RestTestClient.bindTo((MockMvc)((MockMvc)applicationContext.getBean(MockMvc.class)));
        }
        return RestTestClient.bindToApplicationContext((WebApplicationContext)applicationContext);
    }

    private boolean hasBean(ApplicationContext applicationContext, Class<?> type) {
        try {
            applicationContext.getBean(type);
            return true;
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }
}

