/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.resttestclient.autoconfigure;

import java.util.Collection;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.resttestclient.autoconfigure.RestTestClientBuilderCustomizer;
import org.springframework.test.web.servlet.client.RestTestClient;

public class SpringBootRestTestClientBuilderCustomizer
implements RestTestClientBuilderCustomizer {
    private final Collection<ClientHttpMessageConvertersCustomizer> messageConverterCustomizers;

    public SpringBootRestTestClientBuilderCustomizer(Collection<ClientHttpMessageConvertersCustomizer> messageConverterCustomizers) {
        this.messageConverterCustomizers = messageConverterCustomizers;
    }

    @Override
    public void customize(RestTestClient.Builder<?> builder) {
        if (this.messageConverterCustomizers.isEmpty()) {
            return;
        }
        builder.configureMessageConverters(configurer -> this.messageConverterCustomizers.forEach(customizer -> customizer.customize(configurer)));
    }
}

