/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.resttestclient.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.boot.resttestclient.TestRestTemplate;
import org.springframework.boot.test.http.server.LocalTestWebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.web.util.UriTemplateHandler;

@AutoConfiguration
final class TestRestTemplateTestAutoConfiguration {
    TestRestTemplateTestAutoConfiguration() {
    }

    @Bean(name={"org.springframework.boot.resttestclient.TestRestTemplate"})
    @ConditionalOnMissingBean
    TestRestTemplate testRestTemplate(ObjectProvider<RestTemplateBuilder> builderProvider, ApplicationContext applicationContext) {
        RestTemplateBuilder builder = (RestTemplateBuilder)builderProvider.getIfAvailable(() -> new RestTemplateBuilder(new RestTemplateCustomizer[0]));
        LocalTestWebServer localTestWebServer = LocalTestWebServer.obtain((ApplicationContext)applicationContext);
        TestRestTemplate template = new TestRestTemplate(builder, null, null, this.httpClientOptions(localTestWebServer.scheme()));
        template.setUriTemplateHandler((UriTemplateHandler)localTestWebServer.uriBuilderFactory());
        return template;
    }

    private TestRestTemplate.HttpClientOption[] httpClientOptions(LocalTestWebServer.Scheme scheme) {
        TestRestTemplate.HttpClientOption[] httpClientOptionArray;
        switch (scheme) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HTTP: {
                httpClientOptionArray = new TestRestTemplate.HttpClientOption[]{};
                break;
            }
            case HTTPS: {
                TestRestTemplate.HttpClientOption[] httpClientOptionArray2 = new TestRestTemplate.HttpClientOption[1];
                httpClientOptionArray = httpClientOptionArray2;
                httpClientOptionArray2[0] = TestRestTemplate.HttpClientOption.SSL;
            }
        }
        return httpClientOptionArray;
    }
}

