/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure.service;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.autoconfigure.HttpClientAutoConfiguration;
import org.springframework.boot.http.client.autoconfigure.HttpClientProperties;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.RestClientAutoConfiguration;
import org.springframework.boot.restclient.autoconfigure.service.HttpClientServiceProperties;
import org.springframework.boot.restclient.autoconfigure.service.NotReactiveWebApplicationCondition;
import org.springframework.boot.restclient.autoconfigure.service.RestClientCustomizerHttpServiceGroupConfigurer;
import org.springframework.boot.restclient.autoconfigure.service.RestClientPropertiesHttpServiceGroupConfigurer;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.client.support.RestClientAdapter;
import org.springframework.web.service.registry.HttpServiceProxyRegistry;

@AutoConfiguration(after={HttpClientAutoConfiguration.class, RestClientAutoConfiguration.class})
@ConditionalOnClass(value={RestClientAdapter.class})
@ConditionalOnBean(value={HttpServiceProxyRegistry.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={HttpClientServiceProperties.class})
public class HttpServiceClientAutoConfiguration
implements BeanClassLoaderAware {
    private ClassLoader beanClassLoader;

    HttpServiceClientAutoConfiguration() {
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    RestClientPropertiesHttpServiceGroupConfigurer restClientPropertiesHttpServiceGroupConfigurer(ObjectProvider<SslBundles> sslBundles, ObjectProvider<HttpClientProperties> httpClientProperties, HttpClientServiceProperties serviceProperties, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings) {
        return new RestClientPropertiesHttpServiceGroupConfigurer(this.beanClassLoader, sslBundles, (HttpClientProperties)httpClientProperties.getIfAvailable(), serviceProperties, clientFactoryBuilder, clientHttpRequestFactorySettings);
    }

    @Bean
    RestClientCustomizerHttpServiceGroupConfigurer restClientCustomizerHttpServiceGroupConfigurer(ObjectProvider<RestClientCustomizer> customizers) {
        return new RestClientCustomizerHttpServiceGroupConfigurer(customizers);
    }
}

