/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.test.autoconfigure;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.restclient.test.autoconfigure.RestClientTest;
import org.springframework.boot.test.context.filter.annotation.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.util.ClassUtils;

class RestClientTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<RestClientTest> {
    private static final Class<?>[] NO_COMPONENTS = new Class[0];
    private static final String[] OPTIONAL_INCLUDES = new String[]{"tools.jackson.databind.JacksonModule", "org.springframework.boot.jackson.JacksonComponent", "com.fasterxml.jackson.databind.Module", "org.springframework.boot.jackson2.JsonComponent"};
    private static final Set<Class<?>> KNOWN_INCLUDES;
    private final Class<?>[] components = this.getAnnotation().getValue("components", Class[].class).orElse(NO_COMPONENTS);

    RestClientTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    protected Set<Class<?>> getKnownIncludes() {
        return KNOWN_INCLUDES;
    }

    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.components));
    }

    static {
        LinkedHashSet<Class> includes = new LinkedHashSet<Class>();
        for (String optionalInclude : OPTIONAL_INCLUDES) {
            try {
                includes.add(ClassUtils.forName((String)optionalInclude, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KNOWN_INCLUDES = Collections.unmodifiableSet(includes);
    }
}

