/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.reactor.netty;

import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.unix.Errors;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.boot.reactor.netty.GracefulShutdown;
import org.springframework.boot.reactor.netty.NettyRouteProvider;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.netty.ChannelBindException;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerConfig;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.resources.LoopResources;

public class NettyWebServer
implements WebServer {
    private static final int ERROR_NO_EACCES = -13;
    private static final Predicate<HttpServerRequest> ALWAYS = request -> true;
    private static final Log logger = LogFactory.getLog(NettyWebServer.class);
    private final HttpServer httpServer;
    private final BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler;
    private final @Nullable Duration lifecycleTimeout;
    private final @Nullable GracefulShutdown gracefulShutdown;
    private final @Nullable ReactorResourceFactory resourceFactory;
    private List<NettyRouteProvider> routeProviders = Collections.emptyList();
    private volatile @Nullable DisposableServer disposableServer;

    public NettyWebServer(HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, @Nullable Duration lifecycleTimeout, @Nullable Shutdown shutdown, @Nullable ReactorResourceFactory resourceFactory) {
        Assert.notNull((Object)httpServer, (String)"'httpServer' must not be null");
        Assert.notNull((Object)handlerAdapter, (String)"'handlerAdapter' must not be null");
        this.lifecycleTimeout = lifecycleTimeout;
        this.handler = handlerAdapter;
        this.httpServer = httpServer.channelGroup((ChannelGroup)new DefaultChannelGroup((EventExecutor)new DefaultEventExecutor()));
        this.gracefulShutdown = shutdown == Shutdown.GRACEFUL ? new GracefulShutdown(() -> this.disposableServer) : null;
        this.resourceFactory = resourceFactory;
    }

    public void setRouteProviders(List<NettyRouteProvider> routeProviders) {
        this.routeProviders = routeProviders;
    }

    public void start() throws WebServerException {
        DisposableServer disposableServer = this.disposableServer;
        if (disposableServer == null) {
            try {
                this.disposableServer = disposableServer = this.startHttpServer();
            }
            catch (Exception ex) {
                PortInUseException.ifCausedBy((Exception)ex, ChannelBindException.class, bindException -> {
                    if (bindException.localPort() > 0 && !this.isPermissionDenied(bindException.getCause())) {
                        throw new PortInUseException(bindException.localPort(), (Throwable)ex);
                    }
                });
                throw new WebServerException("Unable to start Netty", (Throwable)ex);
            }
            logger.info((Object)this.getStartedOnMessage(disposableServer));
            this.startDaemonAwaitThread(disposableServer);
        }
    }

    private String getStartedOnMessage(DisposableServer server) {
        StringBuilder message = new StringBuilder();
        this.tryAppend(message, "port %s", () -> server.port() + (((HttpServerConfig)this.httpServer.configuration()).sslProvider() != null ? " (https)" : " (http)"));
        this.tryAppend(message, "path %s", () -> ((DisposableServer)server).path());
        return !message.isEmpty() ? "Netty started on " + String.valueOf(message) : "Netty started";
    }

    protected String getStartedLogMessage() {
        DisposableServer disposableServer = this.disposableServer;
        Assert.state((disposableServer != null ? 1 : 0) != 0, (String)"'disposableServer' must not be null");
        return this.getStartedOnMessage(disposableServer);
    }

    private void tryAppend(StringBuilder message, String format, Supplier<Object> supplier) {
        try {
            Object value = supplier.get();
            message.append(!message.isEmpty() ? " " : "");
            message.append(String.format(format, value));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    DisposableServer startHttpServer() {
        HttpServer server = this.httpServer;
        server = this.routeProviders.isEmpty() ? server.handle(this.handler) : server.route(this::applyRouteProviders);
        if (this.resourceFactory != null) {
            LoopResources resources = this.resourceFactory.getLoopResources();
            Assert.state((resources != null ? 1 : 0) != 0, (String)"No LoopResources: is ReactorResourceFactory not initialized yet?");
            server = (HttpServer)server.runOn(resources);
        }
        if (this.lifecycleTimeout != null) {
            return server.bindNow(this.lifecycleTimeout);
        }
        return server.bindNow();
    }

    private boolean isPermissionDenied(@Nullable Throwable bindExceptionCause) {
        try {
            if (bindExceptionCause instanceof Errors.NativeIoException) {
                Errors.NativeIoException nativeException = (Errors.NativeIoException)bindExceptionCause;
                return nativeException.expectedErr() == -13;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void shutDownGracefully(GracefulShutdownCallback callback) {
        if (this.gracefulShutdown == null) {
            callback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        this.gracefulShutdown.shutDownGracefully(callback);
    }

    private void applyRouteProviders(HttpServerRoutes routes) {
        for (NettyRouteProvider provider : this.routeProviders) {
            routes = (HttpServerRoutes)provider.apply(routes);
        }
        routes.route(ALWAYS, this.handler);
    }

    private void startDaemonAwaitThread(final DisposableServer disposableServer) {
        Thread awaitThread = new Thread(this, "server"){
            final /* synthetic */ NettyWebServer this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void run() {
                disposableServer.onDispose().block();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    public void stop() throws WebServerException {
        DisposableServer disposableServer = this.disposableServer;
        if (disposableServer != null) {
            if (this.gracefulShutdown != null) {
                this.gracefulShutdown.abort();
            }
            try {
                if (this.lifecycleTimeout != null) {
                    disposableServer.disposeNow(this.lifecycleTimeout);
                } else {
                    disposableServer.disposeNow();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.disposableServer = null;
        }
    }

    public int getPort() {
        DisposableServer disposableServer = this.disposableServer;
        if (disposableServer != null) {
            try {
                return disposableServer.port();
            }
            catch (UnsupportedOperationException ex) {
                return -1;
            }
        }
        return -1;
    }
}

