/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.reactor.netty.autoconfigure;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.reactor.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.reactor.netty.autoconfigure.NettyServerProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;

public class NettyReactiveWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<NettyReactiveWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;
    private final NettyServerProperties nettyProperties;

    public NettyReactiveWebServerFactoryCustomizer(Environment environment, ServerProperties serverProperties, NettyServerProperties nettyProperties) {
        this.environment = environment;
        this.serverProperties = serverProperties;
        this.nettyProperties = nettyProperties;
    }

    public int getOrder() {
        return 0;
    }

    public void customize(NettyReactiveWebServerFactory factory) {
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.nettyProperties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        map.from(this.nettyProperties::getIdleTimeout).to(idleTimeout -> this.customizeIdleTimeout(factory, (Duration)idleTimeout));
        map.from(this.nettyProperties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory, (int)maxKeepAliveRequests));
        if (this.serverProperties.getHttp2().isEnabled()) {
            map.from((Object)this.serverProperties.getMaxHttpRequestHeaderSize()).to(size -> this.customizeHttp2MaxHeaderSize(factory, size.toBytes()));
        }
        this.customizeRequestDecoder(factory, map);
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive((Environment)this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeConnectionTimeout(NettyReactiveWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(httpServer -> (HttpServer)httpServer.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionTimeout.toMillis())));
    }

    private void customizeRequestDecoder(NettyReactiveWebServerFactory factory, PropertyMapper propertyMapper) {
        factory.addServerCustomizers(httpServer -> httpServer.httpRequestDecoder(httpRequestDecoderSpec -> {
            propertyMapper.from((Object)this.serverProperties.getMaxHttpRequestHeaderSize()).to(maxHttpRequestHeader -> httpRequestDecoderSpec.maxHeaderSize((int)maxHttpRequestHeader.toBytes()));
            propertyMapper.from((Object)this.nettyProperties.getMaxInitialLineLength()).to(maxInitialLineLength -> httpRequestDecoderSpec.maxInitialLineLength((int)maxInitialLineLength.toBytes()));
            propertyMapper.from((Object)this.nettyProperties.getH2cMaxContentLength()).to(h2cMaxContentLength -> httpRequestDecoderSpec.h2cMaxContentLength((int)h2cMaxContentLength.toBytes()));
            propertyMapper.from((Object)this.nettyProperties.getInitialBufferSize()).to(initialBufferSize -> httpRequestDecoderSpec.initialBufferSize((int)initialBufferSize.toBytes()));
            propertyMapper.from((Object)this.nettyProperties.isValidateHeaders()).to(arg_0 -> ((HttpRequestDecoderSpec)httpRequestDecoderSpec).validateHeaders(arg_0));
            return httpRequestDecoderSpec;
        }));
    }

    private void customizeIdleTimeout(NettyReactiveWebServerFactory factory, Duration idleTimeout) {
        factory.addServerCustomizers(httpServer -> httpServer.idleTimeout(idleTimeout));
    }

    private void customizeMaxKeepAliveRequests(NettyReactiveWebServerFactory factory, int maxKeepAliveRequests) {
        factory.addServerCustomizers(httpServer -> httpServer.maxKeepAliveRequests(maxKeepAliveRequests));
    }

    private void customizeHttp2MaxHeaderSize(NettyReactiveWebServerFactory factory, long size) {
        factory.addServerCustomizers(httpServer -> httpServer.http2Settings(settings -> settings.maxHeaderListSize(size)));
    }
}

