/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.init;

import io.r2dbc.spi.ConnectionFactory;
import org.springframework.boot.r2dbc.EmbeddedDatabaseConnection;
import org.springframework.boot.sql.init.AbstractScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.core.io.Resource;
import org.springframework.r2dbc.connection.init.ResourceDatabasePopulator;

public class R2dbcScriptDatabaseInitializer
extends AbstractScriptDatabaseInitializer {
    private final ConnectionFactory connectionFactory;

    public R2dbcScriptDatabaseInitializer(ConnectionFactory connectionFactory, DatabaseInitializationSettings settings) {
        super(settings);
        this.connectionFactory = connectionFactory;
    }

    protected boolean isEmbeddedDatabase() {
        return EmbeddedDatabaseConnection.isEmbedded(this.connectionFactory);
    }

    protected void runScripts(AbstractScriptDatabaseInitializer.Scripts scripts) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(scripts.isContinueOnError());
        populator.setSeparator(scripts.getSeparator());
        if (scripts.getEncoding() != null) {
            populator.setSqlScriptEncoding(scripts.getEncoding().name());
        }
        for (Resource script : scripts) {
            populator.addScript(script);
        }
        populator.populate(this.connectionFactory).block();
    }
}

