/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ClickHouseEnvironment {
    private final String username;
    private final String password;
    private final String database;

    ClickHouseEnvironment(Map<String, String> env) {
        this.username = env.getOrDefault("CLICKHOUSE_USER", "default");
        this.password = this.extractPassword(env);
        this.database = env.getOrDefault("CLICKHOUSE_DB", "default");
    }

    private String extractPassword(Map<String, String> env) {
        boolean allowEmpty = env.containsKey("ALLOW_EMPTY_PASSWORD");
        String password = env.get("CLICKHOUSE_PASSWORD");
        Assert.state((StringUtils.hasLength((String)password) || allowEmpty ? 1 : 0) != 0, (String)"No ClickHouse password found");
        return password != null ? password : "";
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

