/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.pulsar.testcontainers;

import org.springframework.boot.pulsar.autoconfigure.PulsarConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.PulsarContainer;

class PulsarContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<PulsarContainer, PulsarConnectionDetails> {
    PulsarContainerConnectionDetailsFactory() {
    }

    protected PulsarConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<PulsarContainer> source) {
        return new PulsarContainerConnectionDetails(source);
    }

    private static final class PulsarContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<PulsarContainer>
    implements PulsarConnectionDetails {
        private PulsarContainerConnectionDetails(ContainerConnectionSource<PulsarContainer> source) {
            super(source);
        }

        @Override
        public String getBrokerUrl() {
            return ((PulsarContainer)this.getContainer()).getPulsarBrokerUrl();
        }

        @Override
        public String getAdminUrl() {
            return ((PulsarContainer)this.getContainer()).getHttpServiceUrl();
        }
    }
}

