/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.pulsar.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.pulsar.autoconfigure.PropertiesPulsarConnectionDetails;
import org.springframework.boot.pulsar.autoconfigure.PulsarConnectionDetails;
import org.springframework.boot.pulsar.autoconfigure.PulsarContainerFactoryCustomizer;
import org.springframework.boot.pulsar.autoconfigure.PulsarContainerFactoryCustomizers;
import org.springframework.boot.pulsar.autoconfigure.PulsarProperties;
import org.springframework.boot.pulsar.autoconfigure.PulsarPropertiesMapper;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.pulsar.core.DefaultPulsarClientFactory;
import org.springframework.pulsar.core.DefaultSchemaResolver;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.PulsarAdminBuilderCustomizer;
import org.springframework.pulsar.core.PulsarAdministration;
import org.springframework.pulsar.core.PulsarClientBuilderCustomizer;
import org.springframework.pulsar.core.PulsarClientFactory;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.function.PulsarFunction;
import org.springframework.pulsar.function.PulsarFunctionAdministration;
import org.springframework.pulsar.function.PulsarSink;
import org.springframework.pulsar.function.PulsarSource;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={PulsarProperties.class})
class PulsarConfiguration {
    private final PulsarProperties properties;
    private final PulsarPropertiesMapper propertiesMapper;

    PulsarConfiguration(PulsarProperties properties) {
        this.properties = properties;
        this.propertiesMapper = new PulsarPropertiesMapper(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarConnectionDetails.class})
    PropertiesPulsarConnectionDetails pulsarConnectionDetails() {
        return new PropertiesPulsarConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={PulsarClientFactory.class})
    DefaultPulsarClientFactory pulsarClientFactory(PulsarConnectionDetails connectionDetails, ObjectProvider<PulsarClientBuilderCustomizer> customizersProvider) {
        ArrayList<Object> allCustomizers = new ArrayList<Object>();
        allCustomizers.add(builder -> this.propertiesMapper.customizeClientBuilder(builder, connectionDetails));
        allCustomizers.addAll(customizersProvider.orderedStream().toList());
        DefaultPulsarClientFactory clientFactory = new DefaultPulsarClientFactory(clientBuilder -> this.applyClientBuilderCustomizers(allCustomizers, clientBuilder));
        return clientFactory;
    }

    private void applyClientBuilderCustomizers(List<PulsarClientBuilderCustomizer> customizers, ClientBuilder clientBuilder) {
        customizers.forEach(customizer -> customizer.customize(clientBuilder));
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarClient pulsarClient(PulsarClientFactory clientFactory) {
        return clientFactory.createClient();
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarAdministration pulsarAdministration(PulsarConnectionDetails connectionDetails, ObjectProvider<PulsarAdminBuilderCustomizer> pulsarAdminBuilderCustomizers) {
        ArrayList<Object> allCustomizers = new ArrayList<Object>();
        allCustomizers.add(builder -> this.propertiesMapper.customizeAdminBuilder(builder, connectionDetails));
        allCustomizers.addAll(pulsarAdminBuilderCustomizers.orderedStream().toList());
        return new PulsarAdministration(adminBuilder -> this.applyAdminBuilderCustomizers(allCustomizers, adminBuilder));
    }

    private void applyAdminBuilderCustomizers(List<PulsarAdminBuilderCustomizer> customizers, PulsarAdminBuilder adminBuilder) {
        customizers.forEach(customizer -> customizer.customize(adminBuilder));
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaResolver.class})
    DefaultSchemaResolver pulsarSchemaResolver(ObjectProvider<SchemaResolver.SchemaResolverCustomizer<?>> schemaResolverCustomizers) {
        DefaultSchemaResolver schemaResolver = new DefaultSchemaResolver();
        this.addCustomSchemaMappings(schemaResolver, this.properties.getDefaults().getTypeMappings());
        this.applySchemaResolverCustomizers(schemaResolverCustomizers.orderedStream().toList(), schemaResolver);
        return schemaResolver;
    }

    private void addCustomSchemaMappings(DefaultSchemaResolver schemaResolver, @Nullable List<PulsarProperties.Defaults.TypeMapping> typeMappings) {
        if (typeMappings != null) {
            typeMappings.forEach(typeMapping -> this.addCustomSchemaMapping(schemaResolver, (PulsarProperties.Defaults.TypeMapping)typeMapping));
        }
    }

    private void addCustomSchemaMapping(DefaultSchemaResolver schemaResolver, PulsarProperties.Defaults.TypeMapping typeMapping) {
        PulsarProperties.Defaults.SchemaInfo schemaInfo = typeMapping.schemaInfo();
        if (schemaInfo != null) {
            Class<?> messageType = typeMapping.messageType();
            SchemaType schemaType = schemaInfo.schemaType();
            Class<?> messageKeyType = schemaInfo.messageKeyType();
            Schema<Object> schema = this.getSchema(schemaResolver, schemaType, messageType, messageKeyType);
            schemaResolver.addCustomSchemaMapping(typeMapping.messageType(), schema);
        }
    }

    private Schema<Object> getSchema(DefaultSchemaResolver schemaResolver, SchemaType schemaType, Class<?> messageType, @Nullable Class<?> messageKeyType) {
        Schema schema = (Schema)schemaResolver.resolveSchema(schemaType, messageType, messageKeyType).orElseThrow();
        Assert.state((schema != null ? 1 : 0) != 0, (String)"'schema' must not be null");
        return schema;
    }

    private void applySchemaResolverCustomizers(List<SchemaResolver.SchemaResolverCustomizer<?>> customizers, DefaultSchemaResolver schemaResolver) {
        LambdaSafe.callbacks(SchemaResolver.SchemaResolverCustomizer.class, customizers, (Object)schemaResolver, (Object[])new Object[0]).invoke(customizer -> customizer.customize((SchemaResolver)schemaResolver));
    }

    @Bean
    @ConditionalOnMissingBean(value={TopicResolver.class})
    DefaultTopicResolver pulsarTopicResolver() {
        DefaultTopicResolver topicResolver = new DefaultTopicResolver();
        List<PulsarProperties.Defaults.TypeMapping> typeMappings = this.properties.getDefaults().getTypeMappings();
        if (typeMappings != null) {
            typeMappings.forEach(typeMapping -> this.addCustomTopicMapping(topicResolver, (PulsarProperties.Defaults.TypeMapping)typeMapping));
        }
        return topicResolver;
    }

    private void addCustomTopicMapping(DefaultTopicResolver topicResolver, PulsarProperties.Defaults.TypeMapping typeMapping) {
        String topicName = typeMapping.topicName();
        if (topicName != null) {
            topicResolver.addCustomTopicMapping(typeMapping.messageType(), topicName);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.pulsar.function.enabled"}, matchIfMissing=true)
    PulsarFunctionAdministration pulsarFunctionAdministration(PulsarAdministration pulsarAdministration, ObjectProvider<PulsarFunction> pulsarFunctions, ObjectProvider<PulsarSink> pulsarSinks, ObjectProvider<PulsarSource> pulsarSources) {
        PulsarProperties.Function properties = this.properties.getFunction();
        return new PulsarFunctionAdministration(pulsarAdministration, pulsarFunctions, pulsarSinks, pulsarSources, properties.isFailFast(), properties.isPropagateFailures(), properties.isPropagateStopFailures());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.pulsar.defaults.topic.enabled"}, matchIfMissing=true)
    PulsarTopicBuilder pulsarTopicBuilder() {
        return new PulsarTopicBuilder(TopicDomain.persistent, this.properties.getDefaults().getTopic().getTenant(), this.properties.getDefaults().getTopic().getNamespace());
    }

    @Bean
    @ConditionalOnMissingBean
    PulsarContainerFactoryCustomizers pulsarContainerFactoryCustomizers(ObjectProvider<PulsarContainerFactoryCustomizer<?>> customizers) {
        return new PulsarContainerFactoryCustomizers(customizers.orderedStream().toList());
    }
}

