/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.pulsar.autoconfigure;

import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.pulsar.autoconfigure.PulsarProperties;
import org.springframework.util.Assert;

final class DeadLetterPolicyMapper {
    private DeadLetterPolicyMapper() {
    }

    static DeadLetterPolicy map(PulsarProperties.Consumer.DeadLetterPolicy policy) {
        Assert.state((policy.getMaxRedeliverCount() > 0 ? 1 : 0) != 0, (String)"Pulsar DeadLetterPolicy must have a positive 'max-redelivery-count' property value");
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        DeadLetterPolicy.DeadLetterPolicyBuilder builder = DeadLetterPolicy.builder();
        map.from(policy::getMaxRedeliverCount).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).maxRedeliverCount(arg_0));
        map.from(policy::getRetryLetterTopic).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).retryLetterTopic(arg_0));
        map.from(policy::getDeadLetterTopic).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).deadLetterTopic(arg_0));
        map.from(policy::getInitialSubscriptionName).to(arg_0 -> ((DeadLetterPolicy.DeadLetterPolicyBuilder)builder).initialSubscriptionName(arg_0));
        return builder.build();
    }
}

