/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.migrator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.context.properties.migrator.PropertiesMigrationReport;
import org.springframework.boot.context.properties.migrator.PropertyMigration;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class PropertiesMigrationReporter {
    private final Map<String, ConfigurationMetadataProperty> allProperties;
    private final ConfigurableEnvironment environment;

    PropertiesMigrationReporter(ConfigurationMetadataRepository metadataRepository, ConfigurableEnvironment environment) {
        this.allProperties = Collections.unmodifiableMap(metadataRepository.getAllProperties());
        this.environment = environment;
    }

    PropertiesMigrationReport getReport() {
        PropertiesMigrationReport report = new PropertiesMigrationReport();
        Map<String, List<PropertyMigration>> properties = this.getPropertySourceMigrations(ConfigurationMetadataProperty::isDeprecated);
        if (properties.isEmpty()) {
            return report;
        }
        properties.forEach((name, candidates) -> {
            PropertySource<?> propertySource = this.mapPropertiesWithReplacement(report, (String)name, (List<PropertyMigration>)candidates);
            if (propertySource != null) {
                this.environment.getPropertySources().addBefore(name, propertySource);
            }
        });
        return report;
    }

    private Map<String, List<PropertyMigration>> getPropertySourceMigrations(Predicate<ConfigurationMetadataProperty> filter) {
        return this.getPropertySourceMigrations(this.allProperties.values().stream().filter(filter).toList());
    }

    private Map<String, List<PropertyMigration>> getPropertySourceMigrations(List<ConfigurationMetadataProperty> metadataProperties) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.getPropertySourcesAsMap().forEach((arg_0, arg_1) -> this.lambda$getPropertySourceMigrations$0(metadataProperties, (MultiValueMap)result, arg_0, arg_1));
        return result;
    }

    private Map<String, ConfigurationPropertySource> getPropertySourcesAsMap() {
        LinkedHashMap<String, ConfigurationPropertySource> map = new LinkedHashMap<String, ConfigurationPropertySource>();
        for (ConfigurationPropertySource source : ConfigurationPropertySources.get((Environment)this.environment)) {
            map.put(this.determinePropertySourceName(source), source);
        }
        return map;
    }

    private String determinePropertySourceName(ConfigurationPropertySource source) {
        Object object = source.getUnderlyingSource();
        if (object instanceof PropertySource) {
            PropertySource underlyingSource = (PropertySource)object;
            return underlyingSource.getName();
        }
        Object underlyingSource = source.getUnderlyingSource();
        Assert.state((underlyingSource != null ? 1 : 0) != 0, (String)"'underlyingSource' must not be null");
        return underlyingSource.toString();
    }

    private List<PropertyMigration> getMigrations(ConfigurationPropertySource propertySource, ConfigurationMetadataProperty metadataProperty) {
        ConfigurationPropertyName propertyName = this.asConfigurationPropertyName(metadataProperty);
        ArrayList<PropertyMigration> migrations = new ArrayList<PropertyMigration>();
        this.addMigration(propertySource, metadataProperty, propertyName, false, migrations);
        if (this.isMapType(metadataProperty) && propertySource instanceof IterableConfigurationPropertySource) {
            IterableConfigurationPropertySource iterable = (IterableConfigurationPropertySource)propertySource;
            iterable.stream().filter(arg_0 -> ((ConfigurationPropertyName)propertyName).isAncestorOf(arg_0)).forEach(ancestorPropertyName -> this.addMigration(propertySource, metadataProperty, (ConfigurationPropertyName)ancestorPropertyName, true, (List<PropertyMigration>)migrations));
        }
        return migrations;
    }

    private ConfigurationPropertyName asConfigurationPropertyName(ConfigurationMetadataProperty metadataProperty) {
        return ConfigurationPropertyName.isValid((CharSequence)metadataProperty.getId()) ? ConfigurationPropertyName.of((CharSequence)metadataProperty.getId()) : ConfigurationPropertyName.adapt((CharSequence)metadataProperty.getId(), (char)'.');
    }

    private void addMigration(ConfigurationPropertySource propertySource, ConfigurationMetadataProperty metadataProperty, ConfigurationPropertyName propertyName, boolean mapMigration, List<PropertyMigration> migrations) {
        ConfigurationMetadataProperty replacement;
        ConfigurationProperty property = propertySource.getConfigurationProperty(propertyName);
        if (!(property == null || (replacement = this.determineReplacementMetadata(metadataProperty)) != null && this.hasSameName(property, replacement))) {
            migrations.add(new PropertyMigration(property, metadataProperty, replacement, mapMigration));
        }
    }

    private boolean hasSameName(ConfigurationProperty property, ConfigurationMetadataProperty replacement) {
        PropertySourceOrigin propertySourceOrigin;
        Origin origin = property.getOrigin();
        return origin instanceof PropertySourceOrigin && Objects.equals((propertySourceOrigin = (PropertySourceOrigin)origin).getPropertyName(), replacement.getId());
    }

    private @Nullable ConfigurationMetadataProperty determineReplacementMetadata(ConfigurationMetadataProperty metadata) {
        String replacementId = metadata.getDeprecation().getReplacement();
        if (StringUtils.hasText((String)replacementId)) {
            ConfigurationMetadataProperty replacement = this.allProperties.get(replacementId);
            if (replacement != null) {
                return replacement;
            }
            return this.detectMapValueReplacement(replacementId);
        }
        return null;
    }

    private @Nullable ConfigurationMetadataProperty detectMapValueReplacement(String fullId) {
        int lastDot = fullId.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        ConfigurationMetadataProperty metadata = this.allProperties.get(fullId.substring(0, lastDot));
        if (metadata != null && this.isMapType(metadata)) {
            return metadata;
        }
        return null;
    }

    private boolean isMapType(ConfigurationMetadataProperty property) {
        String type = property.getType();
        return type != null && type.startsWith(Map.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable PropertySource<?> mapPropertiesWithReplacement(PropertiesMigrationReport report, String name, List<PropertyMigration> properties) {
        report.add(name, properties);
        List<PropertyMigration> renamed = properties.stream().filter(PropertyMigration::isCompatibleType).toList();
        if (renamed.isEmpty()) {
            return null;
        }
        NameTrackingPropertySource nameTrackingPropertySource = new NameTrackingPropertySource();
        this.environment.getPropertySources().addFirst((PropertySource)nameTrackingPropertySource);
        try {
            String target = "migrate-" + name;
            LinkedHashMap<String, OriginTrackedValue> content = new LinkedHashMap<String, OriginTrackedValue>();
            for (PropertyMigration candidate : renamed) {
                String newPropertyName = candidate.getNewPropertyName();
                Object value = candidate.getProperty().getValue();
                if (nameTrackingPropertySource.isPlaceholderThatAccessesName(value, newPropertyName)) continue;
                OriginTrackedValue originTrackedValue = OriginTrackedValue.of((Object)value, (Origin)candidate.getProperty().getOrigin());
                content.put(newPropertyName, originTrackedValue);
            }
            OriginTrackedMapPropertySource originTrackedMapPropertySource = new OriginTrackedMapPropertySource(target, content);
            return originTrackedMapPropertySource;
        }
        finally {
            this.environment.getPropertySources().remove(nameTrackingPropertySource.getName());
        }
    }

    private /* synthetic */ void lambda$getPropertySourceMigrations$0(List metadataProperties, MultiValueMap result, String propertySourceName, ConfigurationPropertySource propertySource) {
        for (ConfigurationMetadataProperty metadataProperty : metadataProperties) {
            result.addAll((Object)propertySourceName, this.getMigrations(propertySource, metadataProperty));
        }
    }

    private class NameTrackingPropertySource
    extends PropertySource<Object> {
        private final Set<String> accessedNames;

        NameTrackingPropertySource() {
            super(NameTrackingPropertySource.class.getName());
            this.accessedNames = new HashSet<String>();
        }

        boolean isPlaceholderThatAccessesName(Object value, String name) {
            if (value instanceof String) {
                this.accessedNames.clear();
                PropertiesMigrationReporter.this.environment.resolvePlaceholders((String)value);
                return this.accessedNames.contains(name);
            }
            return false;
        }

        public @Nullable Object getProperty(String name) {
            this.accessedNames.add(name);
            return null;
        }
    }
}

