/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.migrator;

import java.util.Comparator;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.TextResourceOrigin;

class PropertyMigration {
    public static final Comparator<PropertyMigration> COMPARATOR = Comparator.comparing(property -> property.getMetadata().getId());
    private final ConfigurationMetadataProperty metadata;
    private final ConfigurationProperty property;
    private final Integer lineNumber;

    PropertyMigration(ConfigurationMetadataProperty metadata, ConfigurationProperty property) {
        this.metadata = metadata;
        this.property = property;
        this.lineNumber = PropertyMigration.determineLineNumber(property);
    }

    private static Integer determineLineNumber(ConfigurationProperty property) {
        TextResourceOrigin textOrigin;
        Origin origin = property.getOrigin();
        if (origin instanceof TextResourceOrigin && (textOrigin = (TextResourceOrigin)origin).getLocation() != null) {
            return textOrigin.getLocation().getLine() + 1;
        }
        return null;
    }

    public ConfigurationMetadataProperty getMetadata() {
        return this.metadata;
    }

    public ConfigurationProperty getProperty() {
        return this.property;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }
}

