/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.autoconfigure.logging;

import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.resources.Resource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import org.springframework.boot.opentelemetry.autoconfigure.logging.SdkLoggerProviderBuilderCustomizer;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={OpenTelemetrySdkAutoConfiguration.class})
@ConditionalOnClass(value={SdkLoggerProvider.class})
public final class OpenTelemetryLoggingAutoConfiguration {
    OpenTelemetryLoggingAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    BatchLogRecordProcessor openTelemetryBatchLogRecordProcessor(ObjectProvider<LogRecordExporter> logRecordExporters) {
        LogRecordExporter exporter = LogRecordExporter.composite(logRecordExporters.orderedStream().toList());
        return BatchLogRecordProcessor.builder((LogRecordExporter)exporter).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Resource.class})
    SdkLoggerProvider openTelemetrySdkLoggerProvider(Resource openTelemetryResource, ObjectProvider<LogRecordProcessor> logRecordProcessors, ObjectProvider<SdkLoggerProviderBuilderCustomizer> customizers) {
        SdkLoggerProviderBuilder builder = SdkLoggerProvider.builder();
        builder.setResource(openTelemetryResource);
        logRecordProcessors.orderedStream().forEach(arg_0 -> ((SdkLoggerProviderBuilder)builder).addLogRecordProcessor(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }
}

