/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.autoconfigure;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryProperties;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryResourceAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnClass(value={OpenTelemetry.class, OpenTelemetrySdk.class})
@EnableConfigurationProperties(value={OpenTelemetryProperties.class})
public final class OpenTelemetrySdkAutoConfiguration {
    OpenTelemetrySdkAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={OpenTelemetry.class})
    OpenTelemetrySdk openTelemetrySdk(ObjectProvider<SdkTracerProvider> openTelemetrySdkTracerProvider, ObjectProvider<ContextPropagators> openTelemetryContextPropagators, ObjectProvider<SdkLoggerProvider> openTelemetrySdkLoggerProvider, ObjectProvider<SdkMeterProvider> openTelemetrySdkMeterProvider) {
        OpenTelemetrySdkBuilder builder = OpenTelemetrySdk.builder();
        openTelemetrySdkTracerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setTracerProvider(arg_0));
        openTelemetryContextPropagators.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setPropagators(arg_0));
        openTelemetrySdkLoggerProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setLoggerProvider(arg_0));
        openTelemetrySdkMeterProvider.ifAvailable(arg_0 -> ((OpenTelemetrySdkBuilder)builder).setMeterProvider(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    Resource openTelemetryResource(Environment environment, OpenTelemetryProperties properties) {
        return Resource.getDefault().merge(this.toResource(environment, properties));
    }

    private Resource toResource(Environment environment, OpenTelemetryProperties properties) {
        ResourceBuilder builder = Resource.builder();
        new OpenTelemetryResourceAttributes(environment, properties.getResourceAttributes()).applyTo((arg_0, arg_1) -> ((ResourceBuilder)builder).put(arg_0, arg_1));
        return builder.build();
    }
}

