/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.opentelemetry.testcontainers;

import org.springframework.boot.opentelemetry.autoconfigure.logging.OpenTelemetryLoggingConnectionDetails;
import org.springframework.boot.opentelemetry.autoconfigure.logging.Transport;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.grafana.LgtmStackContainer;

class GrafanaOpenTelemetryLoggingContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<LgtmStackContainer, OpenTelemetryLoggingConnectionDetails> {
    GrafanaOpenTelemetryLoggingContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, new String[0]);
    }

    protected OpenTelemetryLoggingConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
        return new OpenTelemetryLoggingContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryLoggingContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<LgtmStackContainer>
    implements OpenTelemetryLoggingConnectionDetails {
        private OpenTelemetryLoggingContainerConnectionDetails(ContainerConnectionSource<LgtmStackContainer> source) {
            super(source);
        }

        @Override
        public String getUrl(Transport transport) {
            String url = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> ((LgtmStackContainer)this.getContainer()).getOtlpHttpUrl();
                case Transport.GRPC -> ((LgtmStackContainer)this.getContainer()).getOtlpGrpcUrl();
            };
            return "%s/v1/logs".formatted(url);
        }
    }
}

