/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.autoconfigure;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.Scheme;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.neo4j.autoconfigure.ConfigBuilderCustomizer;
import org.springframework.boot.neo4j.autoconfigure.Neo4jConnectionDetails;
import org.springframework.boot.neo4j.autoconfigure.Neo4jProperties;
import org.springframework.boot.neo4j.autoconfigure.Neo4jSpringJclLogging;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={Driver.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
public final class Neo4jAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Neo4jConnectionDetails.class})
    PropertiesNeo4jConnectionDetails neo4jConnectionDetails(Neo4jProperties properties, ObjectProvider<AuthTokenManager> authTokenManager) {
        return new PropertiesNeo4jConnectionDetails(properties, (AuthTokenManager)authTokenManager.getIfUnique());
    }

    @Bean
    @ConditionalOnMissingBean
    Driver neo4jDriver(Neo4jProperties properties, Environment environment, Neo4jConnectionDetails connectionDetails, ObjectProvider<ConfigBuilderCustomizer> configBuilderCustomizers) {
        Config config = this.mapDriverConfig(properties, connectionDetails, configBuilderCustomizers.orderedStream().toList());
        AuthTokenManager authTokenManager = connectionDetails.getAuthTokenManager();
        if (authTokenManager != null) {
            return GraphDatabase.driver((URI)connectionDetails.getUri(), (AuthTokenManager)authTokenManager, (Config)config);
        }
        AuthToken authToken = connectionDetails.getAuthToken();
        return GraphDatabase.driver((URI)connectionDetails.getUri(), (AuthToken)authToken, (Config)config);
    }

    Config mapDriverConfig(Neo4jProperties properties, Neo4jConnectionDetails connectionDetails, List<ConfigBuilderCustomizer> customizers) {
        Config.ConfigBuilder builder = Config.builder();
        this.configurePoolSettings(builder, properties.getPool());
        URI uri = connectionDetails.getUri();
        String scheme = uri != null ? uri.getScheme() : "bolt";
        this.configureDriverSettings(builder, properties, this.isSimpleScheme(scheme));
        builder.withLogging((Logging)new Neo4jSpringJclLogging());
        customizers.forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    private boolean isSimpleScheme(String scheme) {
        String lowerCaseScheme = scheme.toLowerCase(Locale.ENGLISH);
        try {
            Scheme.validateScheme((String)lowerCaseScheme);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("'%s' is not a supported scheme.", scheme));
        }
        return lowerCaseScheme.equals("bolt") || lowerCaseScheme.equals("neo4j");
    }

    private void configurePoolSettings(Config.ConfigBuilder builder, Neo4jProperties.Pool pool) {
        if (pool.isLogLeakedSessions()) {
            builder.withLeakedSessionsLogging();
        }
        builder.withMaxConnectionPoolSize(pool.getMaxConnectionPoolSize());
        Duration idleTimeBeforeConnectionTest = pool.getIdleTimeBeforeConnectionTest();
        if (idleTimeBeforeConnectionTest != null) {
            builder.withConnectionLivenessCheckTimeout(idleTimeBeforeConnectionTest.toMillis(), TimeUnit.MILLISECONDS);
        }
        builder.withMaxConnectionLifetime(pool.getMaxConnectionLifetime().toMillis(), TimeUnit.MILLISECONDS);
        builder.withConnectionAcquisitionTimeout(pool.getConnectionAcquisitionTimeout().toMillis(), TimeUnit.MILLISECONDS);
        if (pool.isMetricsEnabled()) {
            builder.withDriverMetrics();
        } else {
            builder.withoutDriverMetrics();
        }
    }

    private void configureDriverSettings(Config.ConfigBuilder builder, Neo4jProperties properties, boolean withEncryptionAndTrustSettings) {
        if (withEncryptionAndTrustSettings) {
            this.applyEncryptionAndTrustSettings(builder, properties.getSecurity());
        }
        builder.withConnectionTimeout(properties.getConnectionTimeout().toMillis(), TimeUnit.MILLISECONDS);
        builder.withMaxTransactionRetryTime(properties.getMaxTransactionRetryTime().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void applyEncryptionAndTrustSettings(Config.ConfigBuilder builder, Neo4jProperties.Security securityProperties) {
        if (securityProperties.isEncrypted()) {
            builder.withEncryption();
        } else {
            builder.withoutEncryption();
        }
        builder.withTrustStrategy(this.mapTrustStrategy(securityProperties));
    }

    private Config.TrustStrategy mapTrustStrategy(Neo4jProperties.Security securityProperties) {
        String propertyName = "spring.neo4j.security.trust-strategy";
        Neo4jProperties.Security.TrustStrategy strategy = securityProperties.getTrustStrategy();
        Config.TrustStrategy trustStrategy = this.createTrustStrategy(securityProperties, propertyName, strategy);
        if (securityProperties.isHostnameVerificationEnabled()) {
            trustStrategy.withHostnameVerification();
        } else {
            trustStrategy.withoutHostnameVerification();
        }
        return trustStrategy;
    }

    private Config.TrustStrategy createTrustStrategy(Neo4jProperties.Security securityProperties, String propertyName, Neo4jProperties.Security.TrustStrategy strategy) {
        return switch (strategy) {
            case Neo4jProperties.Security.TrustStrategy.TRUST_ALL_CERTIFICATES -> Config.TrustStrategy.trustAllCertificates();
            case Neo4jProperties.Security.TrustStrategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES -> Config.TrustStrategy.trustSystemCertificates();
            case Neo4jProperties.Security.TrustStrategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES -> {
                File certFile = securityProperties.getCertFile();
                if (certFile == null || !certFile.isFile()) {
                    throw new InvalidConfigurationPropertyValueException(propertyName, (Object)strategy.name(), "Configured trust strategy requires a certificate file.");
                }
                yield Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{certFile});
            }
            default -> throw new InvalidConfigurationPropertyValueException(propertyName, (Object)strategy.name(), "Unknown strategy.");
        };
    }

    static class PropertiesNeo4jConnectionDetails
    implements Neo4jConnectionDetails {
        private final Neo4jProperties properties;
        private final @Nullable AuthTokenManager authTokenManager;

        PropertiesNeo4jConnectionDetails(Neo4jProperties properties, @Nullable AuthTokenManager authTokenManager) {
            this.properties = properties;
            this.authTokenManager = authTokenManager;
        }

        @Override
        public URI getUri() {
            URI uri = this.properties.getUri();
            return uri != null ? uri : Neo4jConnectionDetails.super.getUri();
        }

        @Override
        public AuthToken getAuthToken() {
            Neo4jProperties.Authentication authentication = this.properties.getAuthentication();
            String username = authentication.getUsername();
            String kerberosTicket = authentication.getKerberosTicket();
            boolean hasUsername = StringUtils.hasText((String)username);
            boolean hasKerberosTicket = StringUtils.hasText((String)kerberosTicket);
            Assert.state((!hasUsername || !hasKerberosTicket ? 1 : 0) != 0, () -> "Cannot specify both username ('%s') and kerberos ticket ('%s')".formatted(username, kerberosTicket));
            String password = authentication.getPassword();
            if (hasUsername && StringUtils.hasText((String)password)) {
                return AuthTokens.basic((String)username, (String)password, (String)authentication.getRealm());
            }
            if (hasKerberosTicket) {
                return AuthTokens.kerberos((String)kerberosTicket);
            }
            return AuthTokens.none();
        }

        @Override
        public @Nullable AuthTokenManager getAuthTokenManager() {
            return this.authTokenManager;
        }
    }
}

