/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j.docker.compose;

import java.util.Map;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;

class Neo4jEnvironment {
    private final AuthToken authToken;

    Neo4jEnvironment(Map<String, String> env) {
        AuthToken authToken = this.parse(env.get("NEO4J_AUTH"));
        if (authToken == null && env.containsKey("NEO4J_PASSWORD")) {
            authToken = this.parse("neo4j/" + env.get("NEO4J_PASSWORD"));
        }
        this.authToken = authToken;
    }

    private AuthToken parse(String neo4jAuth) {
        if (neo4jAuth == null) {
            return null;
        }
        if ("none".equals(neo4jAuth)) {
            return AuthTokens.none();
        }
        if (neo4jAuth.startsWith("neo4j/")) {
            return AuthTokens.basic((String)"neo4j", (String)neo4jAuth.substring(6));
        }
        throw new IllegalStateException("Cannot extract auth token from NEO4J_AUTH environment variable with value '" + neo4jAuth + "'. Value should be 'none' to disable authentication or start with 'neo4j/' to specify the neo4j user's password");
    }

    AuthToken getAuthToken() {
        return this.authToken;
    }
}

