/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mustache.servlet.view;

import com.samskivert.mustache.Mustache;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.mustache.servlet.view.MustacheView;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class MustacheViewResolver
extends AbstractTemplateViewResolver {
    private final Mustache.Compiler compiler;
    private @Nullable String charset;

    public MustacheViewResolver() {
        this.compiler = Mustache.compiler();
        this.setViewClass(this.requiredViewClass());
    }

    public MustacheViewResolver(Mustache.Compiler compiler) {
        this.compiler = compiler;
        this.setViewClass(this.requiredViewClass());
    }

    protected Class<?> requiredViewClass() {
        return MustacheView.class;
    }

    public void setCharset(@Nullable String charset) {
        this.charset = charset;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        MustacheView view = (MustacheView)super.buildView(viewName);
        view.setCompiler(this.compiler);
        view.setCharset(this.charset);
        return view;
    }

    protected AbstractUrlBasedView instantiateView() {
        return this.getViewClass() == MustacheView.class ? new MustacheView() : super.instantiateView();
    }
}

