/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.connection.SslSettings;
import org.bson.UuidRepresentation;
import org.springframework.boot.mongodb.autoconfigure.MongoClientSettingsBuilderCustomizer;
import org.springframework.boot.mongodb.autoconfigure.MongoConnectionDetails;
import org.springframework.boot.mongodb.autoconfigure.MongoProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class StandardMongoClientSettingsBuilderCustomizer
implements MongoClientSettingsBuilderCustomizer,
Ordered {
    private final ConnectionString connectionString = null;
    private final UuidRepresentation uuidRepresentation;
    private final MongoConnectionDetails connectionDetails;
    private final MongoProperties.Ssl ssl = null;
    private final SslBundles sslBundles = null;
    private int order = 0;

    public StandardMongoClientSettingsBuilderCustomizer(MongoConnectionDetails connectionDetails, UuidRepresentation uuidRepresentation) {
        this.connectionDetails = connectionDetails;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public void customize(MongoClientSettings.Builder settingsBuilder) {
        settingsBuilder.uuidRepresentation(this.uuidRepresentation);
        if (this.connectionDetails != null) {
            settingsBuilder.applyConnectionString(this.connectionDetails.getConnectionString());
            settingsBuilder.applyToSslSettings(this::configureSslIfNeeded);
        } else {
            settingsBuilder.uuidRepresentation(this.uuidRepresentation);
            settingsBuilder.applyConnectionString(this.connectionString);
            if (this.ssl.isEnabled()) {
                settingsBuilder.applyToSslSettings(this::configureSsl);
            }
        }
    }

    private void configureSsl(SslSettings.Builder settings) {
        settings.enabled(true);
        if (this.ssl.getBundle() != null) {
            SslBundle sslBundle = this.sslBundles.getBundle(this.ssl.getBundle());
            Assert.state((!sslBundle.getOptions().isSpecified() ? 1 : 0) != 0, (String)"SSL options cannot be specified with MongoDB");
            settings.context(sslBundle.createSslContext());
        }
    }

    private void configureSslIfNeeded(SslSettings.Builder settings) {
        SslBundle sslBundle = this.connectionDetails.getSslBundle();
        if (sslBundle != null) {
            settings.enabled(true);
            Assert.state((!sslBundle.getOptions().isSpecified() ? 1 : 0) != 0, (String)"SSL options cannot be specified with MongoDB");
            settings.context(sslBundle.createSslContext());
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

