/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.micrometer.metrics.autoconfigure.MeterValue;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.ServiceLevelObjectiveBoundary;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesMeterFilter
implements MeterFilter {
    private final MetricsProperties properties;
    private final MeterFilter mapFilter;

    public PropertiesMeterFilter(MetricsProperties properties) {
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        this.properties = properties;
        this.mapFilter = PropertiesMeterFilter.createMapFilter(properties.getTags());
    }

    private static MeterFilter createMapFilter(Map<String, String> tags) {
        if (tags.isEmpty()) {
            return new MeterFilter(){};
        }
        Tags commonTags = Tags.of(tags.entrySet().stream().map(PropertiesMeterFilter::asTag).toList());
        return MeterFilter.commonTags((Iterable)commonTags);
    }

    private static Tag asTag(Map.Entry<String, String> entry) {
        return Tag.of((String)entry.getKey(), (String)entry.getValue());
    }

    public MeterFilterReply accept(Meter.Id id) {
        boolean enabled = this.lookupWithFallbackToAll(this.properties.getEnable(), id, true);
        return enabled ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
    }

    public Meter.Id map(Meter.Id id) {
        return this.mapFilter.map(id);
    }

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        MetricsProperties.Distribution distribution = this.properties.getDistribution();
        return DistributionStatisticConfig.builder().percentilesHistogram((Boolean)this.lookupWithFallbackToAll(distribution.getPercentilesHistogram(), id, null)).percentiles((double[])this.lookupWithFallbackToAll(distribution.getPercentiles(), id, null)).serviceLevelObjectives(this.convertServiceLevelObjectives(id.getType(), this.lookup(distribution.getSlo(), id))).minimumExpectedValue(this.convertMeterValue(id.getType(), this.lookup(distribution.getMinimumExpectedValue(), id))).maximumExpectedValue(this.convertMeterValue(id.getType(), this.lookup(distribution.getMaximumExpectedValue(), id))).expiry((Duration)this.lookupWithFallbackToAll(distribution.getExpiry(), id, null)).bufferLength((Integer)this.lookupWithFallbackToAll(distribution.getBufferLength(), id, null)).build().merge(config);
    }

    private double @Nullable [] convertServiceLevelObjectives(Meter.Type meterType, ServiceLevelObjectiveBoundary @Nullable [] slo) {
        if (slo == null) {
            return null;
        }
        double[] converted = Arrays.stream(slo).map((? super T candidate) -> candidate.getValue(meterType)).filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
        return (double[])(converted.length != 0 ? converted : null);
    }

    private @Nullable Double convertMeterValue(Meter.Type meterType, @Nullable String value) {
        return value != null ? MeterValue.valueOf(value).getValue(meterType) : null;
    }

    private <T> @Nullable T lookup(Map<String, T> values, Meter.Id id) {
        if (values.isEmpty()) {
            return null;
        }
        return this.doLookup(values, id);
    }

    @Contract(value="_, _, !null -> !null")
    private <T> @Nullable T lookupWithFallbackToAll(Map<String, T> values, Meter.Id id, @Nullable T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        @Nullable T result = this.doLookup(values, id);
        return result != null ? result : values.getOrDefault("all", defaultValue);
    }

    private <T> @Nullable T doLookup(Map<String, T> values, Meter.Id id) {
        String name = id.getName();
        while (StringUtils.hasLength((String)name)) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return null;
    }
}

