/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure;

import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.core.aop.CountedAspect;
import io.micrometer.core.aop.CountedMeterTagAnnotationHandler;
import io.micrometer.core.aop.MeterTagAnnotationHandler;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import org.aspectj.weaver.Advice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, ObservationAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class, Advice.class})
@ConditionalOnBooleanProperty(value={"management.observations.annotations.enabled"})
@ConditionalOnBean(value={MeterRegistry.class})
public final class MetricsAspectsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    CountedAspect countedAspect(MeterRegistry registry, ObjectProvider<CountedMeterTagAnnotationHandler> countedMeterTagAnnotationHandler) {
        CountedAspect countedAspect = new CountedAspect(registry);
        countedMeterTagAnnotationHandler.ifAvailable(arg_0 -> ((CountedAspect)countedAspect).setMeterTagAnnotationHandler(arg_0));
        return countedAspect;
    }

    @Bean
    @ConditionalOnMissingBean
    TimedAspect timedAspect(MeterRegistry registry, ObjectProvider<MeterTagAnnotationHandler> meterTagAnnotationHandler) {
        TimedAspect timedAspect = new TimedAspect(registry);
        meterTagAnnotationHandler.ifAvailable(arg_0 -> ((TimedAspect)timedAspect).setMeterTagAnnotationHandler(arg_0));
        return timedAspect;
    }

    @ConditionalOnBean(value={ValueExpressionResolver.class})
    static class TagAnnotationHandlersConfiguration {
        TagAnnotationHandlersConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        CountedMeterTagAnnotationHandler countedMeterTagAnnotationHandler(BeanFactory beanFactory, ValueExpressionResolver valueExpressionResolver) {
            return new CountedMeterTagAnnotationHandler(arg_0 -> ((BeanFactory)beanFactory).getBean(arg_0), ignored -> valueExpressionResolver);
        }

        @Bean
        @ConditionalOnMissingBean
        MeterTagAnnotationHandler meterTagAnnotationHandler(BeanFactory beanFactory, ValueExpressionResolver valueExpressionResolver) {
            return new MeterTagAnnotationHandler(arg_0 -> ((BeanFactory)beanFactory).getBean(arg_0), ignored -> valueExpressionResolver);
        }
    }
}

