/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.LibraryScope;

public class ArtifactsLibraries
implements Libraries {
    private static final Map<String, LibraryScope> SCOPES;
    private final Set<Artifact> artifacts;
    private final Set<Artifact> includedArtifacts;
    private final Collection<MavenProject> localProjects;
    private final Collection<Dependency> unpacks;
    private final Log log;

    public ArtifactsLibraries(Set<Artifact> artifacts, Collection<MavenProject> localProjects, Collection<Dependency> unpacks, Log log) {
        this(artifacts, artifacts, localProjects, unpacks, log);
    }

    public ArtifactsLibraries(Set<Artifact> artifacts, Set<Artifact> includedArtifacts, Collection<MavenProject> localProjects, Collection<Dependency> unpacks, Log log) {
        this.artifacts = artifacts;
        this.includedArtifacts = includedArtifacts;
        this.localProjects = localProjects;
        this.unpacks = unpacks;
        this.log = log;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<String> duplicates = this.getDuplicates(this.artifacts);
        for (Artifact artifact : this.artifacts) {
            Object name = this.getFileName(artifact);
            File file = artifact.getFile();
            LibraryScope scope = SCOPES.get(artifact.getScope());
            if (scope == null || file == null) continue;
            if (duplicates.contains(name)) {
                this.log.debug((CharSequence)("Duplicate found: " + (String)name));
                name = artifact.getGroupId() + "-" + (String)name;
                this.log.debug((CharSequence)("Renamed to: " + (String)name));
            }
            ArtifactLibraryCoordinates coordinates = new ArtifactLibraryCoordinates(artifact);
            boolean unpackRequired = this.isUnpackRequired(artifact);
            boolean local = this.isLocal(artifact);
            boolean included = this.includedArtifacts.contains(artifact);
            callback.library(new Library((String)name, file, scope, (LibraryCoordinates)coordinates, unpackRequired, local, included));
        }
    }

    private Set<String> getDuplicates(Set<Artifact> artifacts) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            String fileName = this.getFileName(artifact);
            if (artifact.getFile() == null || seen.add(fileName)) continue;
            duplicates.add(fileName);
        }
        return duplicates;
    }

    private boolean isUnpackRequired(Artifact artifact) {
        if (this.unpacks != null) {
            for (Dependency unpack : this.unpacks) {
                if (!artifact.getGroupId().equals(unpack.getGroupId()) || !artifact.getArtifactId().equals(unpack.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLocal(Artifact artifact) {
        for (MavenProject localProject : this.localProjects) {
            if (localProject.getArtifact().equals(artifact)) {
                return true;
            }
            for (Artifact attachedArtifact : localProject.getAttachedArtifacts()) {
                if (!attachedArtifact.equals(artifact)) continue;
                return true;
            }
        }
        return false;
    }

    private String getFileName(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            sb.append("-").append(classifier);
        }
        sb.append(".").append(artifact.getArtifactHandler().getExtension());
        return sb.toString();
    }

    static {
        HashMap<String, LibraryScope> libraryScopes = new HashMap<String, LibraryScope>();
        libraryScopes.put("compile", LibraryScope.COMPILE);
        libraryScopes.put("runtime", LibraryScope.RUNTIME);
        libraryScopes.put("provided", LibraryScope.PROVIDED);
        libraryScopes.put("system", LibraryScope.PROVIDED);
        SCOPES = Collections.unmodifiableMap(libraryScopes);
    }

    private static class ArtifactLibraryCoordinates
    implements LibraryCoordinates {
        private final Artifact artifact;

        ArtifactLibraryCoordinates(Artifact artifact) {
            this.artifact = artifact;
        }

        public String getGroupId() {
            return this.artifact.getGroupId();
        }

        public String getArtifactId() {
            return this.artifact.getArtifactId();
        }

        public String getVersion() {
            return this.artifact.getBaseVersion();
        }

        public String toString() {
            return this.artifact.toString();
        }
    }
}

