/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactFeatureFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.EnvVariables;
import org.springframework.boot.maven.RunArguments;

public abstract class AbstractRunMojo
extends AbstractDependencyFilterMojo {
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private static final int EXIT_CODE_SIGINT = 130;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(property="spring-boot.run.workingDirectory")
    private File workingDirectory;
    @Parameter(property="spring-boot.run.jvmArguments")
    private String jvmArguments;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private String[] arguments;
    @Parameter(property="spring-boot.run.arguments")
    private String commandlineArguments;
    @Parameter(property="spring-boot.run.profiles")
    private String[] profiles;
    @Parameter(property="spring-boot.run.main-class")
    private String mainClass;
    @Parameter(property="spring-boot.run.directories")
    private String[] directories;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter(property="spring-boot.run.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping run as per configuration.");
            return;
        }
        this.run(this.workingDirectory != null ? this.workingDirectory : this.project.getBasedir(), this.getStartClass(), this.determineEnvironmentVariables());
    }

    protected abstract void run(File var1, String var2, Map<String, String> var3) throws MojoExecutionException, MojoFailureException;

    protected boolean hasTerminatedSuccessfully(int exitCode) {
        return exitCode == 0 || exitCode == 130;
    }

    protected RunArguments resolveApplicationArguments() {
        RunArguments runArguments = this.arguments != null ? new RunArguments(this.arguments) : new RunArguments(this.commandlineArguments);
        this.addActiveProfileArgument(runArguments);
        return runArguments;
    }

    protected String getJavaExecutable() {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        String javaExecutable = toolchain != null ? toolchain.findTool("java") : null;
        return javaExecutable != null ? javaExecutable : new JavaExecutable().toString();
    }

    protected EnvVariables resolveEnvVariables() {
        return new EnvVariables(this.environmentVariables);
    }

    protected void addArgs(List<String> args) {
        RunArguments applicationArguments = this.resolveApplicationArguments();
        Collections.addAll(args, applicationArguments.asArray());
        this.logArguments("Application argument(s): ", applicationArguments.asArray());
    }

    private Map<String, String> determineEnvironmentVariables() {
        EnvVariables envVariables = this.resolveEnvVariables();
        this.logArguments("Environment variable(s): ", envVariables.asArray());
        return envVariables.asMap();
    }

    protected RunArguments resolveJvmArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.systemPropertyVariables != null) {
            stringBuilder.append(this.systemPropertyVariables.entrySet().stream().map(e -> SystemPropertyFormatter.format((String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(" ")));
        }
        if (this.jvmArguments != null) {
            stringBuilder.append(" ").append(this.jvmArguments);
        }
        return new RunArguments(stringBuilder.toString());
    }

    protected void addJvmArgs(List<String> args) {
        RunArguments jvmArguments = this.resolveJvmArguments();
        Collections.addAll(args, jvmArguments.asArray());
        this.logArguments("JVM argument(s): ", jvmArguments.asArray());
    }

    private void addActiveProfileArgument(RunArguments arguments) {
        if (this.profiles.length > 0) {
            StringBuilder arg = new StringBuilder("--spring.profiles.active=");
            for (int i = 0; i < this.profiles.length; ++i) {
                arg.append(this.profiles[i]);
                if (i >= this.profiles.length - 1) continue;
                arg.append(",");
            }
            arguments.getArgs().addFirst(arg.toString());
            this.logArguments("Active profile(s): ", this.profiles);
        }
    }

    protected void addClasspath(List<String> args) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.getClassPathUrls()) {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(new File(ele.toURI()));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Classpath for forked process: " + classpath));
            }
            args.add("-cp");
            args.add(classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    protected String getStartClass() throws MojoExecutionException {
        String mainClass = this.mainClass;
        if (mainClass == null) {
            try {
                mainClass = MainClassFinder.findSingleMainClass((File)this.classesDirectory, (String)SPRING_BOOT_APPLICATION_CLASS_NAME);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        if (mainClass == null) {
            throw new MojoExecutionException("Unable to find a suitable main class, please add a 'mainClass' property");
        }
        return mainClass;
    }

    protected abstract URL[] getClassPathUrls() throws MojoExecutionException;

    protected void addUserDefinedDirectories(List<URL> urls) throws MalformedURLException {
        if (this.directories != null) {
            for (String directory : this.directories) {
                urls.add(new File(directory).toURI().toURL());
            }
        }
    }

    protected void addProjectClasses(List<URL> urls) throws MalformedURLException {
        urls.add(this.classesDirectory.toURI().toURL());
    }

    protected void addDependencies(List<URL> urls, FilterArtifacts filters) throws MalformedURLException, MojoExecutionException {
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), filters);
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
    }

    private void logArguments(String message, String[] args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)Arrays.stream(args).collect(Collectors.joining(" ", message, "")));
        }
    }

    static class SystemPropertyFormatter {
        SystemPropertyFormatter() {
        }

        static String format(String key, String value) {
            if (key == null) {
                return "";
            }
            if (value == null || value.isEmpty()) {
                return String.format("-D%s", key);
            }
            return String.format("-D%s=\"%s\"", key, value);
        }
    }

    static class TestArtifactFilter
    extends AbstractArtifactFeatureFilter {
        TestArtifactFilter() {
            super("", "test");
        }

        protected String getArtifactFeature(Artifact artifact) {
            return artifact.getScope();
        }
    }
}

