/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mail.autoconfigure;

import jakarta.mail.MessagingException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.mail.autoconfigure.MailSenderAutoConfiguration;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@AutoConfiguration(after={MailSenderAutoConfiguration.class})
@ConditionalOnBooleanProperty(value={"spring.mail.test-connection"})
@ConditionalOnSingleCandidate(value=JavaMailSenderImpl.class)
public final class MailSenderValidatorAutoConfiguration {
    private final JavaMailSenderImpl mailSender;

    MailSenderValidatorAutoConfiguration(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
        this.validateConnection();
    }

    private void validateConnection() {
        try {
            this.mailSender.testConnection();
        }
        catch (MessagingException ex) {
            throw new IllegalStateException("Mail server is not available", ex);
        }
    }
}

