/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.util.StringUtils;

public final class BuildPropertiesWriter {
    private final File outputFile;

    public BuildPropertiesWriter(File outputFile) {
        this.outputFile = outputFile;
    }

    public void writeBuildProperties(ProjectDetails projectDetails) throws IOException {
        Properties properties = this.createBuildInfo(projectDetails);
        this.createFileIfNecessary(this.outputFile);
        try (FileOutputStream outputStream = new FileOutputStream(this.outputFile);){
            properties.store(outputStream, "Properties");
        }
    }

    private void createFileIfNecessary(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IllegalStateException("Cannot create parent directory for '" + this.outputFile.getAbsolutePath() + "'");
        }
        if (!file.createNewFile()) {
            throw new IllegalStateException("Cannot create target file '" + this.outputFile.getAbsolutePath() + "'");
        }
    }

    protected Properties createBuildInfo(ProjectDetails project) {
        Properties properties = CollectionFactory.createSortedProperties((boolean)true);
        this.addIfHasValue(properties, "build.group", project.getGroup());
        this.addIfHasValue(properties, "build.artifact", project.getArtifact());
        this.addIfHasValue(properties, "build.name", project.getName());
        this.addIfHasValue(properties, "build.version", project.getVersion());
        if (project.getTime() != null) {
            properties.put("build.time", DateTimeFormatter.ISO_INSTANT.format(project.getTime()));
        }
        if (project.getAdditionalProperties() != null) {
            project.getAdditionalProperties().forEach((name, value) -> properties.put("build." + name, value));
        }
        return properties;
    }

    private void addIfHasValue(Properties properties, String name, @Nullable String value) {
        if (StringUtils.hasText((String)value)) {
            properties.put(name, value);
        }
    }

    public static final class ProjectDetails {
        private final @Nullable String group;
        private final @Nullable String artifact;
        private final @Nullable String name;
        private final @Nullable String version;
        private final @Nullable Instant time;
        private final @Nullable Map<String, String> additionalProperties;

        public ProjectDetails(@Nullable String group, @Nullable String artifact, @Nullable String version, @Nullable String name, @Nullable Instant time, @Nullable Map<String, String> additionalProperties) {
            this.group = group;
            this.artifact = artifact;
            this.name = name;
            this.version = version;
            this.time = time;
            ProjectDetails.validateAdditionalProperties(additionalProperties);
            this.additionalProperties = additionalProperties;
        }

        private static void validateAdditionalProperties(@Nullable Map<String, String> additionalProperties) {
            if (additionalProperties != null) {
                additionalProperties.forEach((name, value) -> {
                    if (value == null) {
                        throw new NullAdditionalPropertyValueException((String)name);
                    }
                });
            }
        }

        public @Nullable String getGroup() {
            return this.group;
        }

        public @Nullable String getArtifact() {
            return this.artifact;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public @Nullable String getVersion() {
            return this.version;
        }

        public @Nullable Instant getTime() {
            return this.time;
        }

        public @Nullable Map<String, String> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static class NullAdditionalPropertyValueException
    extends IllegalArgumentException {
        public NullAdditionalPropertyValueException(String name) {
            super("Additional property '" + name + "' is illegal as its value is null");
        }
    }
}

