/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools.layer;

import java.util.regex.Pattern;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.layer.ContentFilter;
import org.springframework.util.Assert;

public class LibraryContentFilter
implements ContentFilter<Library> {
    private final Pattern pattern;

    public LibraryContentFilter(String coordinatesPattern) {
        Assert.hasText((String)coordinatesPattern, (String)"'coordinatesPattern' must not be empty");
        StringBuilder regex = new StringBuilder();
        for (int i = 0; i < coordinatesPattern.length(); ++i) {
            char c = coordinatesPattern.charAt(i);
            if (c == '.') {
                regex.append("\\.");
                continue;
            }
            if (c == '*') {
                regex.append(".*");
                continue;
            }
            regex.append(c);
        }
        this.pattern = Pattern.compile(regex.toString());
    }

    @Override
    public boolean matches(Library library) {
        return this.pattern.matcher(LibraryCoordinates.toStandardNotationString(library.getCoordinates())).matches();
    }
}

