/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class LayersIndex {
    private final Iterable<Layer> layers;
    private final MultiValueMap<Layer, String> index = new LinkedMultiValueMap();

    public LayersIndex(Iterable<Layer> layers) {
        this.layers = layers;
    }

    public void add(Layer layer, String name) {
        this.index.add((Object)layer, (Object)name);
    }

    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        for (Layer layer : this.layers) {
            List names = (List)this.index.get((Object)layer);
            if (names == null) continue;
            for (String name : names) {
                writer.write(layer.toString());
                writer.write(" ");
                writer.write(name);
                writer.write("\n");
            }
        }
        writer.flush();
    }
}

