/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.springframework.boot.loader.tools.Digest;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.InputStreamSupplier;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LoaderClassesWriter;
import org.springframework.boot.loader.tools.SizeCalculatingEntryWriter;
import org.springframework.boot.loader.tools.ZipHeaderPeekInputStream;

public abstract class AbstractJarWriter
implements LoaderClassesWriter {
    private static final String NESTED_LOADER_JAR = "META-INF/loader/spring-boot-loader.jar";
    private static final int BUFFER_SIZE = 32768;
    private static final int UNIX_FILE_MODE = 33188;
    private static final int UNIX_DIR_MODE = 16877;
    private final Set<String> writtenEntries = new HashSet<String>();

    public void writeManifest(Manifest manifest) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry("META-INF/MANIFEST.MF");
        this.writeEntry(entry, manifest::write);
    }

    public void writeEntries(JarFile jarFile) throws IOException {
        this.writeEntries(jarFile, EntryTransformer.NONE, UnpackHandler.NEVER);
    }

    final void writeEntries(JarFile jarFile, EntryTransformer entryTransformer, UnpackHandler unpackHandler) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarArchiveEntry entry = new JarArchiveEntry(entries.nextElement());
            this.setUpEntry(jarFile, entry);
            ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream((ZipEntry)entry));
            Throwable throwable = null;
            try {
                InputStreamEntryWriter entryWriter = new InputStreamEntryWriter(inputStream, false);
                JarArchiveEntry transformedEntry = entryTransformer.transform(entry);
                if (transformedEntry == null) continue;
                this.writeEntry(transformedEntry, entryWriter, unpackHandler);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
    }

    private void setUpEntry(JarFile jarFile, JarArchiveEntry entry) throws IOException {
        try (ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream((ZipEntry)entry));){
            if (inputStream.hasZipHeader() && entry.getMethod() != 0) {
                new CrcAndSize(inputStream).setupStoredEntry(entry);
            } else {
                entry.setCompressedSize(-1L);
            }
        }
    }

    @Override
    public void writeEntry(String entryName, InputStream inputStream) throws IOException {
        this.writeEntry(entryName, (EntryWriter)new InputStreamEntryWriter(inputStream, true));
    }

    public void writeEntry(String entryName, EntryWriter entryWriter) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry(entryName);
        this.writeEntry(entry, entryWriter);
    }

    public void writeNestedLibrary(String location, Library library) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry(location + library.getName());
        entry.setTime(this.getNestedLibraryTime(library));
        new CrcAndSize(library::openStream).setupStoredEntry(entry);
        this.writeEntry(entry, new InputStreamEntryWriter(library.openStream(), true), new LibraryUnpackHandler(library));
    }

    public void writeIndexFile(String location, Collection<String> lines) throws IOException {
        if (location != null) {
            JarArchiveEntry entry = new JarArchiveEntry(location);
            this.writeEntry(entry, (OutputStream outputStream) -> {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                for (String line : lines) {
                    writer.write(line);
                    writer.write("\n");
                }
                writer.flush();
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNestedLibraryTime(Library library) {
        try (JarInputStream jarStream = new JarInputStream(library.openStream());){
            JarEntry entry = jarStream.getNextJarEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    long l = entry.getTime();
                    return l;
                }
                entry = jarStream.getNextJarEntry();
            }
            return library.getLastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return library.getLastModified();
    }

    @Override
    public void writeLoaderClasses() throws IOException {
        this.writeLoaderClasses(NESTED_LOADER_JAR);
    }

    @Override
    public void writeLoaderClasses(String loaderJarResourceName) throws IOException {
        URL loaderJar = this.getClass().getClassLoader().getResource(loaderJarResourceName);
        try (JarInputStream inputStream = new JarInputStream(new BufferedInputStream(loaderJar.openStream()));){
            JarEntry entry;
            while ((entry = inputStream.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class")) continue;
                this.writeEntry(new JarArchiveEntry(entry), (EntryWriter)new InputStreamEntryWriter(inputStream, false));
            }
        }
    }

    private void writeEntry(JarArchiveEntry entry, EntryWriter entryWriter) throws IOException {
        this.writeEntry(entry, entryWriter, UnpackHandler.NEVER);
    }

    private void writeEntry(JarArchiveEntry entry, EntryWriter entryWriter, UnpackHandler unpackHandler) throws IOException {
        String name = entry.getName();
        this.writeParentFolderEntries(name);
        if (this.writtenEntries.add(name)) {
            entry.setUnixMode(name.endsWith("/") ? 16877 : 33188);
            entry.getGeneralPurposeBit().useUTF8ForNames(true);
            if (!entry.isDirectory() && entry.getSize() == -1L) {
                entryWriter = SizeCalculatingEntryWriter.get(entryWriter);
                entry.setSize((long)entryWriter.size());
            }
            entryWriter = this.addUnpackCommentIfNecessary(entry, entryWriter, unpackHandler);
            this.writeToArchive((ZipEntry)entry, entryWriter);
        }
    }

    protected abstract void writeToArchive(ZipEntry var1, EntryWriter var2) throws IOException;

    private void writeParentFolderEntries(String name) throws IOException {
        String parent;
        String string = parent = name.endsWith("/") ? name.substring(0, name.length() - 1) : name;
        while (parent.lastIndexOf(47) != -1) {
            if ((parent = parent.substring(0, parent.lastIndexOf(47))).isEmpty()) continue;
            this.writeEntry(new JarArchiveEntry(parent + "/"), null, UnpackHandler.NEVER);
        }
    }

    private EntryWriter addUnpackCommentIfNecessary(JarArchiveEntry entry, EntryWriter entryWriter, UnpackHandler unpackHandler) throws IOException {
        if (entryWriter == null || !unpackHandler.requiresUnpack(entry.getName())) {
            return entryWriter;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        entryWriter.write(output);
        entry.setComment("UNPACK:" + unpackHandler.sha1Hash(entry.getName()));
        return new InputStreamEntryWriter(new ByteArrayInputStream(output.toByteArray()), true);
    }

    private static final class LibraryUnpackHandler
    implements UnpackHandler {
        private final Library library;

        private LibraryUnpackHandler(Library library) {
            this.library = library;
        }

        @Override
        public boolean requiresUnpack(String name) {
            return this.library.isUnpackRequired();
        }

        @Override
        public String sha1Hash(String name) throws IOException {
            return Digest.sha1(this.library::openStream);
        }
    }

    static interface UnpackHandler {
        public static final UnpackHandler NEVER = new UnpackHandler(){

            @Override
            public boolean requiresUnpack(String name) {
                return false;
            }

            @Override
            public String sha1Hash(String name) throws IOException {
                throw new UnsupportedOperationException();
            }
        };

        public boolean requiresUnpack(String var1);

        public String sha1Hash(String var1) throws IOException;
    }

    @FunctionalInterface
    static interface EntryTransformer {
        public static final EntryTransformer NONE = jarEntry -> jarEntry;

        public JarArchiveEntry transform(JarArchiveEntry var1);
    }

    private static class CrcAndSize {
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(InputStreamSupplier supplier) throws IOException {
            try (InputStream inputStream = supplier.openStream();){
                this.load(inputStream);
            }
        }

        CrcAndSize(InputStream inputStream) throws IOException {
            this.load(inputStream);
        }

        private void load(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                this.size += (long)bytesRead;
            }
        }

        void setupStoredEntry(JarArchiveEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
        }
    }

    private static class InputStreamEntryWriter
    implements EntryWriter {
        private final InputStream inputStream;
        private final boolean close;

        InputStreamEntryWriter(InputStream inputStream, boolean close) {
            this.inputStream = inputStream;
            this.close = close;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
            if (this.close) {
                this.inputStream.close();
            }
        }
    }
}

