/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.springframework.boot.loader.tools.AbstractJarWriter;
import org.springframework.boot.loader.tools.CustomLoaderLayout;
import org.springframework.boot.loader.tools.DefaultLayoutFactory;
import org.springframework.boot.loader.tools.Digest;
import org.springframework.boot.loader.tools.InputStreamSupplier;
import org.springframework.boot.loader.tools.JarModeLibrary;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.LayeredLayout;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.loader.tools.RepackagingLayout;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class Packager {
    private static final String MAIN_CLASS_ATTRIBUTE = "Main-Class";
    private static final String START_CLASS_ATTRIBUTE = "Start-Class";
    private static final String BOOT_VERSION_ATTRIBUTE = "Spring-Boot-Version";
    private static final String BOOT_CLASSES_ATTRIBUTE = "Spring-Boot-Classes";
    private static final String BOOT_LIB_ATTRIBUTE = "Spring-Boot-Lib";
    private static final String BOOT_CLASSPATH_INDEX_ATTRIBUTE = "Spring-Boot-Classpath-Index";
    private static final String BOOT_LAYERS_INDEX_ATTRIBUTE = "Spring-Boot-Layers-Index";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private List<MainClassTimeoutWarningListener> mainClassTimeoutListeners = new ArrayList<MainClassTimeoutWarningListener>();
    private String mainClass;
    private final File source;
    private Layout layout;
    private LayoutFactory layoutFactory;
    private Layers layers = Layers.IMPLICIT;
    private boolean includeRelevantJarModeJars = true;

    protected Packager(File source, LayoutFactory layoutFactory) {
        Assert.notNull((Object)source, (String)"Source file must not be null");
        Assert.isTrue((source.exists() && source.isFile() ? 1 : 0) != 0, (String)("Source must refer to an existing file, got " + source.getAbsolutePath()));
        this.source = source.getAbsoluteFile();
        this.layoutFactory = layoutFactory;
    }

    public void addMainClassTimeoutWarningListener(MainClassTimeoutWarningListener listener) {
        this.mainClassTimeoutListeners.add(listener);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setLayout(Layout layout) {
        Assert.notNull((Object)layout, (String)"Layout must not be null");
        this.layout = layout;
    }

    public void setLayoutFactory(LayoutFactory layoutFactory) {
        this.layoutFactory = layoutFactory;
    }

    public void setLayers(Layers layers) {
        Assert.notNull((Object)layers, (String)"Layers must not be null");
        this.layers = layers;
    }

    public void setIncludeRelevantJarModeJars(boolean includeRelevantJarModeJars) {
        this.includeRelevantJarModeJars = includeRelevantJarModeJars;
    }

    protected final boolean isAlreadyPackaged() throws IOException {
        return this.isAlreadyPackaged(this.source);
    }

    protected final boolean isAlreadyPackaged(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue(BOOT_VERSION_ATTRIBUTE) != null;
            return bl;
        }
    }

    protected final void write(JarFile sourceJar, Libraries libraries, AbstractJarWriter writer) throws IOException {
        Assert.notNull((Object)libraries, (String)"Libraries must not be null");
        WritableLibraries writeableLibraries = new WritableLibraries(libraries);
        writer.writeManifest(this.buildManifest(sourceJar));
        this.writeLoaderClasses(writer);
        writer.writeEntries(sourceJar, this.getEntityTransformer(), writeableLibraries);
        writeableLibraries.write(writer);
        this.writeLayerIndex(writer);
    }

    private void writeLoaderClasses(AbstractJarWriter writer) throws IOException {
        Layout layout = this.getLayout();
        if (layout instanceof CustomLoaderLayout) {
            ((CustomLoaderLayout)((Object)this.getLayout())).writeLoadedClasses(writer);
        } else if (layout.isExecutable()) {
            writer.writeLoaderClasses();
        }
    }

    private void writeLayerIndex(AbstractJarWriter writer) throws IOException {
        String location;
        if (this.layers != null && this.getLayout() instanceof LayeredLayout && StringUtils.hasLength((String)(location = ((LayeredLayout)this.layout).getLayersIndexFileLocation()))) {
            ArrayList<String> layerNames = new ArrayList<String>();
            this.layers.forEach(layer -> layerNames.add(layer.toString()));
            writer.writeIndexFile(location, layerNames);
        }
    }

    private AbstractJarWriter.EntryTransformer getEntityTransformer() {
        if (this.getLayout() instanceof RepackagingLayout) {
            return new RepackagingEntryTransformer((RepackagingLayout)this.getLayout(), this.layers);
        }
        return AbstractJarWriter.EntryTransformer.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isZip(InputStreamSupplier supplier) {
        try (InputStream inputStream = supplier.openStream();){
            boolean bl = this.isZip(inputStream);
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (byte magicByte : ZIP_FILE_HEADER) {
            if (inputStream.read() == magicByte) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        Manifest manifest = this.createInitialManifest(source);
        this.addMainAndStartAttributes(source, manifest);
        this.addBootAttributes(manifest.getMainAttributes());
        return manifest;
    }

    private Manifest createInitialManifest(JarFile source) throws IOException {
        if (source.getManifest() != null) {
            return new Manifest(source.getManifest());
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        return manifest;
    }

    private void addMainAndStartAttributes(JarFile source, Manifest manifest) throws IOException {
        String mainClass = this.getMainClass(source, manifest);
        String launcherClass = this.getLayout().getLauncherClassName();
        if (launcherClass != null) {
            Assert.state((mainClass != null ? 1 : 0) != 0, (String)"Unable to find main class");
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, launcherClass);
            manifest.getMainAttributes().putValue(START_CLASS_ATTRIBUTE, mainClass);
        } else if (mainClass != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, mainClass);
        }
    }

    private String getMainClass(JarFile source, Manifest manifest) throws IOException {
        if (this.mainClass != null) {
            return this.mainClass;
        }
        String attributeValue = manifest.getMainAttributes().getValue(MAIN_CLASS_ATTRIBUTE);
        if (attributeValue != null) {
            return attributeValue;
        }
        return this.findMainMethodWithTimeoutWarning(source);
    }

    private String findMainMethodWithTimeoutWarning(JarFile source) throws IOException {
        long startTime = System.currentTimeMillis();
        String mainMethod = this.findMainMethod(source);
        long duration = System.currentTimeMillis() - startTime;
        if (duration > FIND_WARNING_TIMEOUT) {
            for (MainClassTimeoutWarningListener listener : this.mainClassTimeoutListeners) {
                listener.handleTimeoutWarning(duration, mainMethod);
            }
        }
        return mainMethod;
    }

    protected String findMainMethod(JarFile source) throws IOException {
        return MainClassFinder.findSingleMainClass(source, this.getLayout().getClassesLocation(), SPRING_BOOT_APPLICATION_CLASS_NAME);
    }

    public final File getBackupFile() {
        File source = this.getSource();
        return new File(source.getParentFile(), source.getName() + ".original");
    }

    protected final File getSource() {
        return this.source;
    }

    protected final Layout getLayout() {
        if (this.layout == null) {
            Layout createdLayout = this.getLayoutFactory().getLayout(this.source);
            Assert.state((createdLayout != null ? 1 : 0) != 0, (String)"Unable to detect layout");
            this.layout = createdLayout;
        }
        return this.layout;
    }

    private LayoutFactory getLayoutFactory() {
        if (this.layoutFactory != null) {
            return this.layoutFactory;
        }
        List factories = SpringFactoriesLoader.loadFactories(LayoutFactory.class, null);
        if (factories.isEmpty()) {
            return new DefaultLayoutFactory();
        }
        Assert.state((factories.size() == 1 ? 1 : 0) != 0, (String)"No unique LayoutFactory found");
        return (LayoutFactory)factories.get(0);
    }

    private void addBootAttributes(Attributes attributes) {
        attributes.putValue(BOOT_VERSION_ATTRIBUTE, this.getClass().getPackage().getImplementationVersion());
        Layout layout = this.getLayout();
        if (layout instanceof LayeredLayout) {
            this.addBootBootAttributesForLayeredLayout(attributes, (LayeredLayout)layout);
        } else if (layout instanceof RepackagingLayout) {
            this.addBootBootAttributesForRepackagingLayout(attributes, (RepackagingLayout)layout);
        } else {
            this.addBootBootAttributesForPlainLayout(attributes, layout);
        }
    }

    private void addBootBootAttributesForLayeredLayout(Attributes attributes, LayeredLayout layout) {
        this.putIfHasLength(attributes, BOOT_LAYERS_INDEX_ATTRIBUTE, layout.getLayersIndexFileLocation());
        this.putIfHasLength(attributes, BOOT_CLASSPATH_INDEX_ATTRIBUTE, layout.getClasspathIndexFileLocation());
    }

    private void addBootBootAttributesForRepackagingLayout(Attributes attributes, RepackagingLayout layout) {
        attributes.putValue(BOOT_CLASSES_ATTRIBUTE, layout.getRepackagedClassesLocation());
        this.putIfHasLength(attributes, BOOT_LIB_ATTRIBUTE, this.getLayout().getLibraryLocation("", LibraryScope.COMPILE));
        this.putIfHasLength(attributes, BOOT_CLASSPATH_INDEX_ATTRIBUTE, layout.getClasspathIndexFileLocation());
    }

    private void addBootBootAttributesForPlainLayout(Attributes attributes, Layout layout) {
        attributes.putValue(BOOT_CLASSES_ATTRIBUTE, this.getLayout().getClassesLocation());
        this.putIfHasLength(attributes, BOOT_LIB_ATTRIBUTE, this.getLayout().getLibraryLocation("", LibraryScope.COMPILE));
    }

    private void putIfHasLength(Attributes attributes, String name, String value) {
        if (StringUtils.hasLength((String)value)) {
            attributes.putValue(name, value);
        }
    }

    private final class WritableLibraries
    implements AbstractJarWriter.UnpackHandler {
        private final Map<String, Library> libraries = new LinkedHashMap<String, Library>();

        WritableLibraries(Libraries libraries) throws IOException {
            libraries.doWithLibraries(library -> {
                if (Packager.this.isZip(library::openStream)) {
                    this.addLibrary(library);
                }
            });
            if (Packager.this.includeRelevantJarModeJars && Packager.this.getLayout() instanceof LayeredLayout) {
                this.addLibrary(JarModeLibrary.LAYER_TOOLS);
            }
        }

        private void addLibrary(Library library) {
            String location = this.getLocation(library);
            if (location != null) {
                String path = location + library.getName();
                Library existing = this.libraries.putIfAbsent(path, library);
                Assert.state((existing == null ? 1 : 0) != 0, () -> "Duplicate library " + library.getName());
            }
        }

        private String getLocation(Library library) {
            Layout layout = Packager.this.getLayout();
            if (layout instanceof LayeredLayout) {
                Layers layers = Packager.this.layers;
                Layer layer = layers.getLayer(library);
                Assert.state((layer != null ? 1 : 0) != 0, () -> "Invalid 'null' library layer from " + layers.getClass().getName());
                return ((LayeredLayout)layout).getLibraryLocation(library.getName(), library.getScope(), layer);
            }
            return layout.getLibraryLocation(library.getName(), library.getScope());
        }

        @Override
        public boolean requiresUnpack(String name) {
            Library library = this.libraries.get(name);
            return library != null && library.isUnpackRequired();
        }

        @Override
        public String sha1Hash(String name) throws IOException {
            Library library = this.libraries.get(name);
            Assert.notNull((Object)library, () -> "No library found for entry name '" + name + "'");
            return Digest.sha1(library::openStream);
        }

        private void write(AbstractJarWriter writer) throws IOException {
            for (Map.Entry<String, Library> entry : this.libraries.entrySet()) {
                String path = entry.getKey();
                Library library = entry.getValue();
                String location = path.substring(0, path.lastIndexOf(47) + 1);
                writer.writeNestedLibrary(location, library);
            }
            if (Packager.this.getLayout() instanceof RepackagingLayout) {
                String location = ((RepackagingLayout)Packager.this.getLayout()).getClasspathIndexFileLocation();
                writer.writeIndexFile(location, this.libraries.keySet());
            }
        }
    }

    private static final class RepackagingEntryTransformer
    implements AbstractJarWriter.EntryTransformer {
        private final RepackagingLayout layout;
        private final Layers layers;

        private RepackagingEntryTransformer(RepackagingLayout layout, Layers layers) {
            this.layout = layout;
            this.layers = layers;
        }

        @Override
        public JarArchiveEntry transform(JarArchiveEntry entry) {
            if (entry.getName().equals("META-INF/INDEX.LIST")) {
                return null;
            }
            if (!this.isTransformable(entry)) {
                return entry;
            }
            String transformedName = this.transformName(entry.getName());
            JarArchiveEntry transformedEntry = new JarArchiveEntry(transformedName);
            transformedEntry.setTime(entry.getTime());
            transformedEntry.setSize(entry.getSize());
            transformedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                transformedEntry.setComment(entry.getComment());
            }
            transformedEntry.setCompressedSize(entry.getCompressedSize());
            transformedEntry.setCrc(entry.getCrc());
            if (entry.getCreationTime() != null) {
                transformedEntry.setCreationTime(entry.getCreationTime());
            }
            if (entry.getExtra() != null) {
                transformedEntry.setExtra(entry.getExtra());
            }
            if (entry.getLastAccessTime() != null) {
                transformedEntry.setLastAccessTime(entry.getLastAccessTime());
            }
            if (entry.getLastModifiedTime() != null) {
                transformedEntry.setLastModifiedTime(entry.getLastModifiedTime());
            }
            return transformedEntry;
        }

        private String transformName(String name) {
            if (this.layout instanceof LayeredLayout) {
                Layer layer = this.layers.getLayer(name);
                Assert.state((layer != null ? 1 : 0) != 0, () -> "Invalid 'null' layer from " + this.layers.getClass().getName());
                return ((LayeredLayout)this.layout).getRepackagedClassesLocation(layer) + name;
            }
            return this.layout.getRepackagedClassesLocation() + name;
        }

        private boolean isTransformable(JarArchiveEntry entry) {
            String name = entry.getName();
            if (name.startsWith("META-INF/")) {
                return name.equals("META-INF/aop.xml") || name.endsWith(".kotlin_module");
            }
            return !name.startsWith("BOOT-INF/") && !name.equals("module-info.class");
        }
    }

    @FunctionalInterface
    public static interface MainClassTimeoutWarningListener {
        public void handleTimeoutWarning(long var1, String var3);
    }
}

