/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;

public abstract class MainClassFinder {
    private static final String DOT_CLASS = ".class";
    private static final Type STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type MAIN_METHOD_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_ARRAY_TYPE});
    private static final String MAIN_METHOD_NAME = "main";
    private static final FileFilter CLASS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(MainClassFinder.DOT_CLASS);
        }
    };
    private static final FileFilter PACKAGE_FOLDER_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith(".");
        }
    };

    public static String findMainClass(File rootFolder) throws IOException {
        return MainClassFinder.doWithMainClasses(rootFolder, new ClassNameCallback<String>(){

            @Override
            public String doWith(String className) {
                return className;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithMainClasses(File rootFolder, ClassNameCallback<T> callback) throws IOException {
        if (!rootFolder.exists()) {
            return null;
        }
        if (!rootFolder.isDirectory()) {
            throw new IllegalArgumentException("Invalid root folder '" + rootFolder + "'");
        }
        String prefix = rootFolder.getAbsolutePath() + "/";
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(rootFolder);
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isFile()) {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    String className;
                    T result;
                    if (MainClassFinder.isMainClass(inputStream) && (result = callback.doWith(className = MainClassFinder.convertToClassName(file.getAbsolutePath(), prefix))) != null) {
                        T t = result;
                        return t;
                    }
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            if (!file.isDirectory()) continue;
            MainClassFinder.pushAllSorted(stack, file.listFiles(PACKAGE_FOLDER_FILTER));
            MainClassFinder.pushAllSorted(stack, file.listFiles(CLASS_FILE_FILTER));
        }
        return null;
    }

    private static void pushAllSorted(Deque<File> stack, File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file : files) {
            stack.push(file);
        }
    }

    public static String findMainClass(JarFile jarFile, String classesLocation) throws IOException {
        return MainClassFinder.doWithMainClasses(jarFile, classesLocation, new ClassNameCallback<String>(){

            @Override
            public String doWith(String className) {
                return className;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithMainClasses(JarFile jarFile, String classesLocation, ClassNameCallback<T> callback) throws IOException {
        List<JarEntry> classEntries = MainClassFinder.getClassEntries(jarFile, classesLocation);
        Collections.sort(classEntries, new ClassEntryComparator());
        for (JarEntry entry : classEntries) {
            BufferedInputStream inputStream = new BufferedInputStream(jarFile.getInputStream(entry));
            try {
                String className;
                T result;
                if (!MainClassFinder.isMainClass(inputStream) || (result = callback.doWith(className = MainClassFinder.convertToClassName(entry.getName(), classesLocation))) == null) continue;
                T t = result;
                return t;
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        return null;
    }

    private static String convertToClassName(String name, String prefix) {
        name = name.replace("/", ".");
        name = name.replace('\\', '.');
        name = name.substring(0, name.length() - DOT_CLASS.length());
        if (prefix != null) {
            name = name.substring(prefix.length());
        }
        return name;
    }

    private static List<JarEntry> getClassEntries(JarFile source, String classesLocation) {
        classesLocation = classesLocation != null ? classesLocation : "";
        Enumeration<JarEntry> sourceEntries = source.entries();
        ArrayList<JarEntry> classEntries = new ArrayList<JarEntry>();
        while (sourceEntries.hasMoreElements()) {
            JarEntry entry = sourceEntries.nextElement();
            if (!entry.getName().startsWith(classesLocation) || !entry.getName().endsWith(DOT_CLASS)) continue;
            classEntries.add(entry);
        }
        return classEntries;
    }

    private static boolean isMainClass(InputStream inputStream) {
        try {
            ClassReader classReader = new ClassReader(inputStream);
            MainMethodFinder mainMethodFinder = new MainMethodFinder();
            classReader.accept((ClassVisitor)mainMethodFinder, 1);
            return mainMethodFinder.isFound();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static interface ClassNameCallback<T> {
        public T doWith(String var1);
    }

    private static class MainMethodFinder
    extends ClassVisitor {
        private boolean found;

        public MainMethodFinder() {
            super(262144);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isAccess(access, 1, 8) && MainClassFinder.MAIN_METHOD_NAME.equals(name) && MAIN_METHOD_TYPE.getDescriptor().equals(desc)) {
                this.found = true;
            }
            return null;
        }

        private boolean isAccess(int access, int ... requiredOpsCodes) {
            for (int requiredOpsCode : requiredOpsCodes) {
                if ((access & requiredOpsCode) != 0) continue;
                return false;
            }
            return true;
        }

        public boolean isFound() {
            return this.found;
        }
    }

    private static class ClassEntryComparator
    implements Comparator<JarEntry> {
        private ClassEntryComparator() {
        }

        @Override
        public int compare(JarEntry o1, JarEntry o2) {
            Integer d2;
            Integer d1 = this.getDepth(o1);
            int depthCompare = d1.compareTo(d2 = Integer.valueOf(this.getDepth(o2)));
            if (depthCompare != 0) {
                return depthCompare;
            }
            return o1.getName().compareTo(o2.getName());
        }

        private int getDepth(JarEntry entry) {
            return entry.getName().split("/").length;
        }
    }
}

