/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jooq.autoconfigure;

import javax.sql.DataSource;
import org.jooq.SQLDialect;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jooq.autoconfigure.SqlDialectLookup;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="spring.jooq")
public class JooqProperties {
    private SQLDialect sqlDialect;
    private Resource config;

    public SQLDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SQLDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
    }

    public SQLDialect determineSqlDialect(DataSource dataSource) {
        if (this.sqlDialect != null) {
            return this.sqlDialect;
        }
        return SqlDialectLookup.getDialect(dataSource);
    }
}

