/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms.autoconfigure;

import jakarta.jms.ConnectionFactory;
import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jms.autoconfigure.AbstractJmsListenerContainerFactoryConfigurer;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.transaction.jta.JtaTransactionManager;

public final class DefaultJmsListenerContainerFactoryConfigurer
extends AbstractJmsListenerContainerFactoryConfigurer<DefaultJmsListenerContainerFactory> {
    private @Nullable JtaTransactionManager transactionManager;

    void setTransactionManager(@Nullable JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void configure(DefaultJmsListenerContainerFactory factory, ConnectionFactory connectionFactory) {
        super.configure(factory, connectionFactory);
        PropertyMapper map = PropertyMapper.get();
        JmsProperties.Listener listenerProperties = this.getJmsProperties().getListener();
        JmsProperties.Listener.Session sessionProperties = listenerProperties.getSession();
        map.from((Object)this.transactionManager).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setTransactionManager(arg_0));
        if (this.transactionManager == null && sessionProperties.getTransacted() == null) {
            factory.setSessionTransacted(Boolean.valueOf(true));
        }
        map.from(listenerProperties::formatConcurrency).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setConcurrency(arg_0));
        map.from(listenerProperties::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setReceiveTimeout(arg_0));
        map.from(listenerProperties::getMaxMessagesPerTask).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory).setMaxMessagesPerTask(arg_0));
    }
}

