/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms.autoconfigure.health;

import jakarta.jms.ConnectionFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.jms.autoconfigure.JmsAutoConfiguration;
import org.springframework.boot.jms.health.JmsHealthIndicator;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, JmsHealthIndicator.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="jms")
public class JmsHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<JmsHealthIndicator, ConnectionFactory> {
    public JmsHealthContributorAutoConfiguration() {
        super(JmsHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"jmsHealthIndicator", "jmsHealthContributor"})
    public HealthContributor jmsHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, ConnectionFactory.class);
    }
}

