/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure;

import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.VirtualThreadPool;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class JettyVirtualThreadsWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    private final @Nullable JettyServerProperties serverProperties;

    @Deprecated(since="4.0.3", forRemoval=true)
    public JettyVirtualThreadsWebServerFactoryCustomizer() {
        this(null);
    }

    public JettyVirtualThreadsWebServerFactoryCustomizer(JettyServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void customize(ConfigurableJettyWebServerFactory factory) {
        Assert.state((boolean)VirtualThreads.areSupported(), (String)"Virtual threads are not supported");
        Integer maxTasks = this.getMaxTasks();
        VirtualThreadPool virtualThreadPool = maxTasks != null ? new VirtualThreadPool(maxTasks.intValue()) : new VirtualThreadPool();
        virtualThreadPool.setName("jetty-");
        factory.setThreadPool((ThreadPool)virtualThreadPool);
    }

    private @Nullable Integer getMaxTasks() {
        if (this.serverProperties == null) {
            return null;
        }
        Integer maxThreads = this.serverProperties.getThreads().getMax();
        return maxThreads > 0 ? maxThreads : null;
    }

    public int getOrder() {
        return 1;
    }
}

