/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure;

import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.jetty.autoconfigure.JettyThreadPool;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class JettyVirtualThreadsWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered,
EnvironmentAware {
    private final JettyServerProperties jettyProperties;
    private final boolean bind;

    public JettyVirtualThreadsWebServerFactoryCustomizer(JettyServerProperties jettyProperties) {
        this.jettyProperties = jettyProperties;
        this.bind = false;
    }

    public void customize(ConfigurableJettyWebServerFactory factory) {
        Assert.state((boolean)VirtualThreads.areSupported(), (String)"Virtual threads are not supported");
        QueuedThreadPool threadPool = JettyThreadPool.create(this.jettyProperties.getThreads());
        threadPool.setVirtualThreadsExecutor(VirtualThreads.getNamedVirtualThreadsExecutor((String)"jetty-"));
        factory.setThreadPool((ThreadPool)threadPool);
    }

    public int getOrder() {
        return 1;
    }

    public void setEnvironment(Environment environment) {
        if (this.bind) {
            Binder.get((Environment)environment).bind("server.jetty", Bindable.ofInstance((Object)this.jettyProperties));
        }
    }
}

