/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.autoconfigure.reactive;

import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Server;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.jetty.autoconfigure.JettyWebServerConfiguration;
import org.springframework.boot.jetty.autoconfigure.reactive.WebSocketJettyReactiveWebServerFactoryCustomizer;
import org.springframework.boot.jetty.reactive.JettyReactiveWebServerFactory;
import org.springframework.boot.web.server.autoconfigure.reactive.ReactiveWebServerConfiguration;
import org.springframework.boot.web.server.reactive.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.ReactiveHttpInputMessage;

@AutoConfiguration
@ConditionalOnClass(value={Server.class, ServletHolder.class, ReactiveHttpInputMessage.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={JettyServerProperties.class})
@Import(value={JettyWebServerConfiguration.class, ReactiveWebServerConfiguration.class})
public class JettyReactiveWebServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    JettyReactiveWebServerFactory jettyReactiveWebServerFactory(ObjectProvider<JettyServerCustomizer> serverCustomizers) {
        JettyReactiveWebServerFactory serverFactory = new JettyReactiveWebServerFactory();
        serverFactory.getServerCustomizers().addAll(serverCustomizers.orderedStream().toList());
        return serverFactory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JakartaWebSocketServletContainerInitializer.class})
    static class JettyWebSocketConfiguration {
        JettyWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketReactiveWebServerCustomizer"})
        WebSocketJettyReactiveWebServerFactoryCustomizer websocketServletWebServerCustomizer() {
            return new WebSocketJettyReactiveWebServerFactoryCustomizer();
        }
    }
}

