/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jersey.actuate.endpoint.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.glassfish.jersey.server.model.Resource;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.health.actuate.endpoint.AdditionalHealthEndpointPath;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroup;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroups;
import org.springframework.boot.jersey.actuate.endpoint.web.JerseyEndpointResourceFactory;

public final class JerseyHealthEndpointAdditionalPathResourceFactory {
    private final JerseyEndpointResourceFactory delegate = new JerseyEndpointResourceFactory();
    private final Set<HealthEndpointGroup> groups;
    private final WebServerNamespace serverNamespace;

    public JerseyHealthEndpointAdditionalPathResourceFactory(WebServerNamespace serverNamespace, HealthEndpointGroups groups) {
        this.serverNamespace = serverNamespace;
        this.groups = groups.getAllWithAdditionalPath(serverNamespace);
    }

    public Collection<Resource> createEndpointResources(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints) {
        return endpoints.stream().flatMap(endpoint -> endpoint.getOperations().stream()).flatMap(operation -> this.createResources(endpointMapping, (WebOperation)operation)).toList();
    }

    private Stream<Resource> createResources(EndpointMapping endpointMapping, WebOperation operation) {
        WebOperationRequestPredicate requestPredicate = operation.getRequestPredicate();
        String matchAllRemainingPathSegmentsVariable = requestPredicate.getMatchAllRemainingPathSegmentsVariable();
        if (matchAllRemainingPathSegmentsVariable != null) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (HealthEndpointGroup group : this.groups) {
                AdditionalHealthEndpointPath additionalPath = group.getAdditionalPath();
                if (additionalPath == null) continue;
                resources.add(this.delegate.getResource(endpointMapping, operation, requestPredicate, additionalPath.getValue(), this.serverNamespace, (data, pathSegmentsVariable) -> data.getUriInfo().getPath()));
            }
            return resources.stream();
        }
        return Stream.empty();
    }
}

