/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.jdbc")
public class JdbcProperties {
    private final Template template = new Template();

    public Template getTemplate() {
        return this.template;
    }

    public static class Template {
        private boolean ignoreWarnings = true;
        private int fetchSize = -1;
        private int maxRows = -1;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private @Nullable Duration queryTimeout;
        private boolean skipResultsProcessing;
        private boolean skipUndeclaredResults;
        private boolean resultsMapCaseInsensitive;

        public boolean isIgnoreWarnings() {
            return this.ignoreWarnings;
        }

        public void setIgnoreWarnings(boolean ignoreWarnings) {
            this.ignoreWarnings = ignoreWarnings;
        }

        public int getFetchSize() {
            return this.fetchSize;
        }

        public void setFetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
        }

        public int getMaxRows() {
            return this.maxRows;
        }

        public void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }

        public @Nullable Duration getQueryTimeout() {
            return this.queryTimeout;
        }

        public void setQueryTimeout(@Nullable Duration queryTimeout) {
            this.queryTimeout = queryTimeout;
        }

        public boolean isSkipResultsProcessing() {
            return this.skipResultsProcessing;
        }

        public void setSkipResultsProcessing(boolean skipResultsProcessing) {
            this.skipResultsProcessing = skipResultsProcessing;
        }

        public boolean isSkipUndeclaredResults() {
            return this.skipUndeclaredResults;
        }

        public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
            this.skipUndeclaredResults = skipUndeclaredResults;
        }

        public boolean isResultsMapCaseInsensitive() {
            return this.resultsMapCaseInsensitive;
        }

        public void setResultsMapCaseInsensitive(boolean resultsMapCaseInsensitive) {
            this.resultsMapCaseInsensitive = resultsMapCaseInsensitive;
        }
    }
}

