/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.docker.compose;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PostgresEnvironment {
    private static final String[] USERNAME_KEYS = new String[]{"POSTGRES_USER", "POSTGRESQL_USER", "POSTGRESQL_USERNAME"};
    private static final String DEFAULT_USERNAME = "postgres";
    private static final String[] DATABASE_KEYS = new String[]{"POSTGRES_DB", "POSTGRESQL_DB", "POSTGRESQL_DATABASE"};
    private final String username;
    private final String password;
    private final String database;

    PostgresEnvironment(Map<String, String> env) {
        this.username = this.extract(env, USERNAME_KEYS, DEFAULT_USERNAME);
        this.password = this.extractPassword(env);
        this.database = this.extract(env, DATABASE_KEYS, this.username);
    }

    private String extract(Map<String, String> env, String[] keys, String defaultValue) {
        for (String key : keys) {
            if (!env.containsKey(key)) continue;
            return env.get(key);
        }
        return defaultValue;
    }

    private String extractPassword(Map<String, String> env) {
        if (this.isUsingTrustHostAuthMethod(env)) {
            return null;
        }
        String password = env.getOrDefault("POSTGRES_PASSWORD", env.get("POSTGRESQL_PASSWORD"));
        boolean allowEmpty = env.containsKey("ALLOW_EMPTY_PASSWORD");
        Assert.state((allowEmpty || StringUtils.hasLength((String)password) ? 1 : 0) != 0, (String)"No PostgreSQL password found");
        return password != null ? password : "";
    }

    private boolean isUsingTrustHostAuthMethod(Map<String, String> env) {
        String hostAuthMethod = env.get("POSTGRES_HOST_AUTH_METHOD");
        return "trust".equals(hostAuthMethod);
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

