/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jarmode.layertools;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import org.springframework.util.Assert;

class Context {
    private final File archiveFile;
    private final File workingDir;
    private final String relativeDir;

    Context() {
        this(Context.getSourceArchiveFile(), Paths.get(".", new String[0]).toAbsolutePath().normalize().toFile());
    }

    Context(File archiveFile, File workingDir) {
        Assert.state((boolean)this.isExistingFile(archiveFile), (String)"Unable to find source archive");
        Assert.state((boolean)this.isJarOrWar(archiveFile), (String)("Source archive " + archiveFile + " must end with .jar or .war"));
        this.archiveFile = archiveFile;
        this.workingDir = workingDir;
        this.relativeDir = this.deduceRelativeDir(archiveFile.getParentFile(), this.workingDir);
    }

    private boolean isExistingFile(File archiveFile) {
        return archiveFile != null && archiveFile.isFile() && archiveFile.exists();
    }

    private boolean isJarOrWar(File jarFile) {
        String name = jarFile.getName().toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".war");
    }

    private static File getSourceArchiveFile() {
        try {
            File source;
            ProtectionDomain domain = Context.class.getProtectionDomain();
            CodeSource codeSource = domain != null ? domain.getCodeSource() : null;
            URL location = codeSource != null ? codeSource.getLocation() : null;
            File file = source = location != null ? Context.findSource(location) : null;
            if (source != null && source.exists()) {
                return source.getAbsoluteFile();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static File findSource(URL location) throws IOException, URISyntaxException {
        URLConnection connection = location.openConnection();
        if (connection instanceof JarURLConnection) {
            return Context.getRootJarFile(((JarURLConnection)connection).getJarFile());
        }
        return new File(location.toURI());
    }

    private static File getRootJarFile(JarFile jarFile) {
        String name = jarFile.getName();
        int separator = name.indexOf("!/");
        if (separator > 0) {
            name = name.substring(0, separator);
        }
        return new File(name);
    }

    private String deduceRelativeDir(File sourceDirectory, File workingDir) {
        String workingPath;
        String sourcePath = sourceDirectory.getAbsolutePath();
        if (sourcePath.equals(workingPath = workingDir.getAbsolutePath()) || !sourcePath.startsWith(workingPath)) {
            return null;
        }
        String relativePath = sourcePath.substring(workingPath.length() + 1);
        return !relativePath.isEmpty() ? relativePath : null;
    }

    File getArchiveFile() {
        return this.archiveFile;
    }

    File getWorkingDir() {
        return this.workingDir;
    }

    String getRelativeArchiveDir() {
        return this.relativeDir;
    }
}

