/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.jackson.JacksonComponent;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.module.SimpleModule;

public class JacksonComponentModule
extends SimpleModule
implements BeanFactoryAware,
InitializingBean {
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.registerJacksonComponents();
    }

    public void registerJacksonComponents() {
        BeanFactory beanFactory = this.beanFactory;
        while (beanFactory != null) {
            BeanFactory beanFactory2;
            if (beanFactory instanceof ListableBeanFactory) {
                ListableBeanFactory listableBeanFactory = (ListableBeanFactory)beanFactory;
                this.addJacksonComponentBeans(listableBeanFactory);
            }
            if (beanFactory instanceof HierarchicalBeanFactory) {
                HierarchicalBeanFactory hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactory;
                beanFactory2 = hierarchicalBeanFactory.getParentBeanFactory();
            } else {
                beanFactory2 = null;
            }
            beanFactory = beanFactory2;
        }
    }

    private void addJacksonComponentBeans(ListableBeanFactory beanFactory) {
        Map beans = beanFactory.getBeansWithAnnotation(JacksonComponent.class);
        for (Object bean : beans.values()) {
            this.addJacksonComponentBean(bean);
        }
    }

    private void addJacksonComponentBean(Object bean) {
        MergedAnnotation annotation = MergedAnnotations.from(bean.getClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JacksonComponent.class);
        Class[] types = annotation.getClassArray("type");
        JacksonComponent.Scope scope = (JacksonComponent.Scope)annotation.getEnum("scope", JacksonComponent.Scope.class);
        this.addJacksonComponentBean(bean, types, scope);
    }

    private void addJacksonComponentBean(Object bean, Class<?>[] types, JacksonComponent.Scope scope) {
        if (bean instanceof ValueSerializer) {
            ValueSerializer jsonSerializer = (ValueSerializer)bean;
            this.addValueSerializerBean(jsonSerializer, scope, types);
        } else if (bean instanceof ValueDeserializer) {
            ValueDeserializer jsonDeserializer = (ValueDeserializer)bean;
            this.addValueDeserializerBean(jsonDeserializer, types);
        } else if (bean instanceof KeyDeserializer) {
            KeyDeserializer keyDeserializer = (KeyDeserializer)bean;
            this.addKeyDeserializerBean(keyDeserializer, types);
        }
        for (Class<?> innerClass : bean.getClass().getDeclaredClasses()) {
            if (!JacksonComponentModule.isSuitableInnerClass(innerClass)) continue;
            Object innerInstance = BeanUtils.instantiateClass(innerClass);
            this.addJacksonComponentBean(innerInstance, types, scope);
        }
    }

    private static boolean isSuitableInnerClass(Class<?> innerClass) {
        return !Modifier.isAbstract(innerClass.getModifiers()) && (ValueSerializer.class.isAssignableFrom(innerClass) || ValueDeserializer.class.isAssignableFrom(innerClass) || KeyDeserializer.class.isAssignableFrom(innerClass));
    }

    private <T> void addValueSerializerBean(ValueSerializer<T> serializer, JacksonComponent.Scope scope, Class<?>[] types) {
        Class baseType = ResolvableType.forClass(ValueSerializer.class, serializer.getClass()).resolveGeneric(new int[0]);
        Assert.state((baseType != null ? 1 : 0) != 0, (String)"'baseType' must not be null");
        this.addBeanToModule(serializer, baseType, types, scope == JacksonComponent.Scope.VALUES ? (arg_0, arg_1) -> ((JacksonComponentModule)this).addSerializer(arg_0, arg_1) : (arg_0, arg_1) -> ((JacksonComponentModule)this).addKeySerializer(arg_0, arg_1));
    }

    private <T> void addValueDeserializerBean(ValueDeserializer<T> deserializer, Class<?>[] types) {
        Class baseType = ResolvableType.forClass(ValueDeserializer.class, deserializer.getClass()).resolveGeneric(new int[0]);
        Assert.state((baseType != null ? 1 : 0) != 0, (String)"'baseType' must not be null");
        this.addBeanToModule(deserializer, baseType, types, (arg_0, arg_1) -> ((JacksonComponentModule)this).addDeserializer(arg_0, arg_1));
    }

    private void addKeyDeserializerBean(KeyDeserializer deserializer, Class<?>[] types) {
        Assert.notEmpty((Object[])types, (String)"'types' must not be empty");
        this.addBeanToModule(deserializer, Object.class, types, (arg_0, arg_1) -> ((JacksonComponentModule)this).addKeyDeserializer(arg_0, arg_1));
    }

    private <E, T> void addBeanToModule(E element, Class<T> baseType, Class<?>[] types, BiConsumer<Class<T>, E> consumer) {
        if (ObjectUtils.isEmpty((Object[])types)) {
            consumer.accept(baseType, element);
            return;
        }
        for (Class<?> type : types) {
            Assert.isAssignable(baseType, type);
            consumer.accept(type, element);
        }
    }

    private static final class JacksonComponentAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Map<Class<?>, List<Class<?>>> innerComponents;

        private JacksonComponentAotContribution(Map<Class<?>, List<Class<?>>> innerComponents) {
            this.innerComponents = innerComponents;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
            this.innerComponents.forEach((outer, inners) -> {
                reflection.registerType(outer, new MemberCategory[0]);
                inners.forEach(inner -> reflection.registerType(inner, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
            });
        }
    }

    static class JacksonComponentBeanFactoryInitializationAotProcessor
    implements BeanFactoryInitializationAotProcessor {
        JacksonComponentBeanFactoryInitializationAotProcessor() {
        }

        public @Nullable BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
            String[] jacksonComponents = beanFactory.getBeanNamesForAnnotation(JacksonComponent.class);
            HashMap innerComponents = new HashMap();
            for (String jacksonComponent : jacksonComponents) {
                Class type = beanFactory.getType(jacksonComponent, true);
                Assert.state((type != null ? 1 : 0) != 0, (String)"'type' must not be null");
                for (Class<?> declaredClass : type.getDeclaredClasses()) {
                    if (!JacksonComponentModule.isSuitableInnerClass(declaredClass)) continue;
                    innerComponents.computeIfAbsent(type, t -> new ArrayList()).add(declaredClass);
                }
            }
            return innerComponents.isEmpty() ? null : new JacksonComponentAotContribution(innerComponents);
        }
    }
}

