/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@Deprecated(since="4.0.0", forRemoval=true)
class Jackson2HttpMessageConvertersConfiguration {
    Jackson2HttpMessageConvertersConfiguration() {
    }

    private static class PreferJackson2OrJacksonUnavailableCondition
    extends AnyNestedCondition {
        PreferJackson2OrJacksonUnavailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={JacksonHttpMessageConvertersConfiguration.JacksonJsonHttpMessageConvertersCustomizer.class})
        static class JacksonUnavailable {
            JacksonUnavailable() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson2")
        static class Jackson2Preferred {
            Jackson2Preferred() {
            }
        }
    }

    static class Jackson2XmlMessageConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final ObjectMapper objectMapper;

        Jackson2XmlMessageConvertersCustomizer(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withXmlConverter((HttpMessageConverter)new MappingJackson2XmlHttpMessageConverter(this.objectMapper));
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withXmlConverter((HttpMessageConverter)new MappingJackson2XmlHttpMessageConverter(this.objectMapper));
        }
    }

    static class Jackson2JsonMessageConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final ObjectMapper objectMapper;

        Jackson2JsonMessageConvertersCustomizer(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)new MappingJackson2HttpMessageConverter(this.objectMapper));
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)new MappingJackson2HttpMessageConverter(this.objectMapper));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={XmlMapper.class})
    @ConditionalOnBean(value={Jackson2ObjectMapperBuilder.class})
    protected static class MappingJackson2XmlHttpMessageConverterConfiguration {
        protected MappingJackson2XmlHttpMessageConverterConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnMissingBean(value={MappingJackson2XmlHttpMessageConverter.class})
        Jackson2XmlMessageConvertersCustomizer mappingJackson2XmlHttpMessageConverter(Jackson2ObjectMapperBuilder builder) {
            return new Jackson2XmlMessageConvertersCustomizer(builder.createXmlMapper(true).build());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @Conditional(value={PreferJackson2OrJacksonUnavailableCondition.class})
    static class MappingJackson2HttpMessageConverterConfiguration {
        MappingJackson2HttpMessageConverterConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnMissingBean(value={MappingJackson2HttpMessageConverter.class})
        Jackson2JsonMessageConvertersCustomizer jackson2HttpMessageConvertersCustomizer(ObjectMapper objectMapper) {
            return new Jackson2JsonMessageConvertersCustomizer(objectMapper);
        }
    }
}

