/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.converter.xml.JacksonXmlHttpMessageConverter;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.dataformat.xml.XmlMapper;

@Configuration(proxyBeanMethods=false)
class JacksonHttpMessageConvertersConfiguration {
    JacksonHttpMessageConvertersConfiguration() {
    }

    static class JacksonXmlHttpMessageConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final XmlMapper xmlMapper;

        JacksonXmlHttpMessageConvertersCustomizer(XmlMapper xmlMapper) {
            this.xmlMapper = xmlMapper;
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withXmlConverter((HttpMessageConverter)new JacksonXmlHttpMessageConverter(this.xmlMapper));
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withXmlConverter((HttpMessageConverter)new JacksonXmlHttpMessageConverter(this.xmlMapper));
        }
    }

    static class JacksonJsonHttpMessageConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final JsonMapper jsonMapper;

        JacksonJsonHttpMessageConvertersCustomizer(JsonMapper jsonMapper) {
            this.jsonMapper = jsonMapper;
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)new JacksonJsonHttpMessageConverter(this.jsonMapper));
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)new JacksonJsonHttpMessageConverter(this.jsonMapper));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={XmlMapper.class})
    @ConditionalOnBean(value={XmlMapper.class})
    protected static class JacksonXmlHttpMessageConverterConfiguration {
        protected JacksonXmlHttpMessageConverterConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnMissingBean(value={JacksonXmlHttpMessageConverter.class})
        JacksonXmlHttpMessageConvertersCustomizer jacksonXmlHttpMessageConvertersCustomizer(XmlMapper xmlMapper) {
            return new JacksonXmlHttpMessageConvertersCustomizer(xmlMapper);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JsonMapper.class})
    @ConditionalOnBean(value={JsonMapper.class})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    static class JacksonJsonHttpMessageConverterConfiguration {
        JacksonJsonHttpMessageConverterConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnMissingBean(value={JacksonJsonHttpMessageConverter.class}, ignoredType={"org.springframework.hateoas.server.mvc.TypeConstrainedJacksonJsonHttpMessageConverter", "org.springframework.data.rest.webmvc.alps.AlpsJacksonJsonHttpMessageConverter"})
        JacksonJsonHttpMessageConvertersCustomizer jacksonJsonHttpMessageConvertersCustomizer(JsonMapper jsonMapper) {
            return new JacksonJsonHttpMessageConvertersCustomizer(jsonMapper);
        }
    }
}

