/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.codec.autoconfigure;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.http.codec.autoconfigure.HttpCodecsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.client.WebClient;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration"})
@ConditionalOnClass(value={CodecConfigurer.class, WebClient.class})
public final class CodecsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={HttpCodecsProperties.class})
    static class DefaultCodecsConfiguration {
        DefaultCodecsConfiguration() {
        }

        @Bean
        DefaultCodecCustomizer defaultCodecCustomizer(HttpCodecsProperties httpCodecProperties) {
            return new DefaultCodecCustomizer(httpCodecProperties.isLogRequestDetails(), httpCodecProperties.getMaxInMemorySize());
        }

        static final class DefaultCodecCustomizer
        implements CodecCustomizer,
        Ordered {
            private final boolean logRequestDetails;
            private final @Nullable DataSize maxInMemorySize;

            DefaultCodecCustomizer(boolean logRequestDetails, @Nullable DataSize maxInMemorySize) {
                this.logRequestDetails = logRequestDetails;
                this.maxInMemorySize = maxInMemorySize;
            }

            @Override
            public void customize(CodecConfigurer configurer) {
                PropertyMapper map = PropertyMapper.get();
                CodecConfigurer.DefaultCodecs defaultCodecs = configurer.defaultCodecs();
                defaultCodecs.enableLoggingRequestDetails(this.logRequestDetails);
                map.from((Object)this.maxInMemorySize).asInt(DataSize::toBytes).to(arg_0 -> ((CodecConfigurer.DefaultCodecs)defaultCodecs).maxInMemorySize(arg_0));
            }

            public int getOrder() {
                return 0;
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonJsonCodecConfiguration {
        JacksonJsonCodecConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={JsonMapper.class})
        CodecCustomizer jacksonCodecCustomizer(JsonMapper jsonMapper) {
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jacksonJsonDecoder((Decoder)new JacksonJsonDecoder(jsonMapper));
                defaults.jacksonJsonEncoder((Encoder)new JacksonJsonEncoder(jsonMapper));
            };
        }
    }
}

