/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;

public record HttpClientSettings(@Nullable HttpRedirects redirects, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
    private static final HttpClientSettings defaults = new HttpClientSettings(null, null, null, null);

    public HttpClientSettings withConnectTimeout(@Nullable Duration connectTimeout) {
        return new HttpClientSettings(this.redirects, connectTimeout, this.readTimeout, this.sslBundle);
    }

    public HttpClientSettings withReadTimeout(@Nullable Duration readTimeout) {
        return new HttpClientSettings(this.redirects, this.connectTimeout, readTimeout, this.sslBundle);
    }

    public HttpClientSettings withTimeouts(@Nullable Duration connectTimeout, @Nullable Duration readTimeout) {
        return new HttpClientSettings(this.redirects, connectTimeout, readTimeout, this.sslBundle);
    }

    public HttpClientSettings withSslBundle(@Nullable SslBundle sslBundle) {
        return new HttpClientSettings(this.redirects, this.connectTimeout, this.readTimeout, sslBundle);
    }

    public HttpClientSettings withRedirects(@Nullable HttpRedirects redirects) {
        return new HttpClientSettings(redirects, this.connectTimeout, this.readTimeout, this.sslBundle);
    }

    public HttpClientSettings orElse(@Nullable HttpClientSettings other) {
        if (other == null) {
            return this;
        }
        HttpRedirects redirects = this.redirects() != null ? this.redirects() : other.redirects();
        Duration connectTimeout = this.connectTimeout() != null ? this.connectTimeout() : other.connectTimeout();
        Duration readTimeout = this.readTimeout() != null ? this.readTimeout() : other.readTimeout();
        SslBundle sslBundle = this.sslBundle() != null ? this.sslBundle() : other.sslBundle();
        return new HttpClientSettings(redirects, connectTimeout, readTimeout, sslBundle);
    }

    public static HttpClientSettings ofSslBundle(@Nullable SslBundle sslBundle) {
        return HttpClientSettings.defaults().withSslBundle(sslBundle);
    }

    public static HttpClientSettings defaults() {
        return defaults;
    }
}

