/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.reactive;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.autoconfigure.reactive.AbstractClientHttpConnectorProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.StringUtils;

public final class ClientHttpConnectors {
    private final ObjectFactory<SslBundles> sslBundles;
    private final @Nullable AbstractClientHttpConnectorProperties[] orderedProperties;
    private final @Nullable ClientHttpConnectorBuilder<?> fallbackBuilder;
    private final @Nullable ClientHttpConnectorSettings fallbackSettings;

    public ClientHttpConnectors(ObjectFactory<SslBundles> sslBundles, AbstractClientHttpConnectorProperties ... orderedProperties) {
        this(null, null, sslBundles, orderedProperties);
    }

    public ClientHttpConnectors(@Nullable ClientHttpConnectorBuilder<?> fallbackBuilder, @Nullable ClientHttpConnectorSettings fallbackSettings, ObjectFactory<SslBundles> sslBundles, AbstractClientHttpConnectorProperties ... orderedProperties) {
        this.fallbackBuilder = fallbackBuilder;
        this.fallbackSettings = fallbackSettings;
        this.sslBundles = sslBundles;
        this.orderedProperties = orderedProperties;
    }

    public ClientHttpConnectorBuilder<?> builder(@Nullable ClassLoader classLoader) {
        AbstractClientHttpConnectorProperties.Connector connector = this.getProperty(AbstractClientHttpConnectorProperties::getConnector, Objects::nonNull, null, Function.identity());
        if (connector != null) {
            return connector.builder();
        }
        return this.fallbackBuilder != null ? this.fallbackBuilder : ClientHttpConnectorBuilder.detect(classLoader);
    }

    public ClientHttpConnectorSettings settings() {
        HttpRedirects redirects = this.getProperty(AbstractClientHttpConnectorProperties::getRedirects, Objects::nonNull, this.fallbackSettings, ClientHttpConnectorSettings::redirects);
        Duration connectTimeout = this.getProperty(AbstractClientHttpConnectorProperties::getConnectTimeout, Objects::nonNull, this.fallbackSettings, ClientHttpConnectorSettings::connectTimeout);
        Duration readTimeout = this.getProperty(AbstractClientHttpConnectorProperties::getReadTimeout, Objects::nonNull, this.fallbackSettings, ClientHttpConnectorSettings::readTimeout);
        String sslBundleName = this.getProperty(AbstractClientHttpConnectorProperties::getSsl, AbstractClientHttpConnectorProperties.Ssl::getBundle, StringUtils::hasText, null, Function.identity());
        SslBundle sslBundle = StringUtils.hasLength((String)sslBundleName) ? ((SslBundles)this.sslBundles.getObject()).getBundle(sslBundleName) : this.fallbackSslBundle();
        return new ClientHttpConnectorSettings(redirects, connectTimeout, readTimeout, sslBundle);
    }

    private @Nullable SslBundle fallbackSslBundle() {
        return this.fallbackSettings != null ? this.fallbackSettings.sslBundle() : null;
    }

    private <T, F> @Nullable T getProperty(Function<AbstractClientHttpConnectorProperties, @Nullable T> accessor, Predicate<@Nullable T> predicate, @Nullable F fallback, Function<F, @Nullable T> fallbackAccessor) {
        return this.getProperty(accessor, Function.identity(), predicate, fallback, fallbackAccessor);
    }

    private <P, T, F> @Nullable T getProperty(Function<AbstractClientHttpConnectorProperties, @Nullable P> accessor, Function<@Nullable P, @Nullable T> extractor, Predicate<@Nullable T> predicate, @Nullable F fallback, Function<F, @Nullable T> fallbackAccessor) {
        for (AbstractClientHttpConnectorProperties properties : this.orderedProperties) {
            T extracted;
            if (properties == null) continue;
            P value = accessor.apply(properties);
            T t = extracted = value != null ? (T)extractor.apply(value) : null;
            if (!predicate.test(extracted)) continue;
            return extracted;
        }
        return fallback != null ? (T)fallbackAccessor.apply(fallback) : null;
    }
}

